package com.flybits.commons.library.logging;

/**
 * Logger is an internal class that used to log information to the logcat.
 */
public class Logger {

    static final String DEFAULT_TAG = "FlybitsSDK";

    private static Displayer displayer = new Displayer(DEFAULT_TAG);

    /**
     * Set the Tag that the logcat information is set under.
     *
     * @param tag The tag that is used to display information within the logcat under.
     * @return The {@link Displayer} that displays the information in the logcat.
     */
    public static Displayer setTag(String tag){
        return displayer.changeTag(tag);
    }

    /**
     * Retrieve the {@link Displayer} that displays information within the logcat.
     *
     * @return The {@link Displayer} that displays the information in the logcat.
     */
    public static Displayer getDisplayer(){
        return displayer;
    }

    /**
     * Creates a log statement in the logcat that displays information used to debug the Flybits
     * SDK.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    public static void d(String msg){
        displayer.changeTag(DEFAULT_TAG);
        displayer.d(msg);
    }

    /**
     * Creates a log statement in the logcat that displays an error.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    public static void e(String msg){
        displayer.changeTag(DEFAULT_TAG);
        displayer.e(msg);
    }

    /**
     * Creates a log statement in the logcat that displays some information.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    public static void i(String msg){
        displayer.changeTag(DEFAULT_TAG);
        displayer.i(msg);
    }

    /**
     * Creates a log statement in the logcat that displays a warning.
     *
     * @param msg - The message to be displayed in the logcat.
     */
    public static void w(String msg){
        displayer.changeTag(DEFAULT_TAG);
        displayer.w(msg);
    }

    /**
     * Creates a log statement in the logcat that will display an exception's information and print
     * the stack trace. This is only available is the user has set activated logging when they
     * initiate Flybits for the first time.
     *
     * @param e - The exception to display information about.
     * TODO: Missing @param
     */
    public static void exception(String sdkMethod, Exception e){

        //caughtFailure(sdkMethod, e.getMessage(), null);

        displayer.changeTag(DEFAULT_TAG);
        displayer.exception(e);
    }
}
