package com.flybits.commons.library.exceptions;

/**
 *  The {@code InvalidParameterException} is thrown whenever an invalid parameter is entered in an
 *  SDK method. For example, if a method has a parameter that contains a {@code @NonNull} annotation
 *  and an application sends {@code null} as that parameter, the {@code InvalidParameterException}
 *  is thrown.
 *
 *  @since 1.0.0
 */
public class InvalidParameterException extends FlybitsException{

    private String className;
    private String method;

    /**
     * Constructs a new {@code InvalidParameterException} that is thrown whenever an invalid
     * parameter is entered into an SDK method.
     *
     * @param message The {@code message} of the error.
     * @param className The name of the class that threw the {@code InvalidParameterException}.
     * @param method The name of the method that threw the {@code InvalidParameterException} within
     *               the {@code className} class.
     */
    public InvalidParameterException(String message, String className, String method){
        super(message);
        this.method         = method;
        this.className      = className;
    }

    /**
     * Get the name of the class where the invalid parameter was entered.
     *
     * @return The class name where the exception occurred.
     */
    public String getClassName() {
        return className;
    }

    /**
     * Get the name of the method where the invalid parameter was entered.
     *
     * @return The method name where the exception occurred.
     */
    public String getMethod() {
        return method;
    }
}
