/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.internal.models.preferences;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.JsonParser;
import com.flybits.commons.library.models.internal.Result;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FlybitsPreferences {
    static MediaType MEDIA_TYPE_PLAIN = MediaType.parse((String)"text/plain; charset=utf-8");
    static final String API_USER_PREF = "/kernel/userpref";
    private Context context;
    private Handler handler;
    private ExecutorService executorService;

    public FlybitsPreferences(Context context) {
        this.context = context;
        this.handler = new Handler(Looper.getMainLooper());
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public FlybitsPreferences(Context context, Handler handler) {
        this.context = context;
        this.handler = handler;
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public BasicResult clear(BasicResultCallback callback) {
        return this.delete(this.context, null, callback);
    }

    public ObjectResult<Boolean> getBoolean(String key, boolean defaultValue, ObjectResultCallback<Boolean> callback) {
        return this.get(this.context, key, defaultValue, Boolean.class, callback);
    }

    public ObjectResult<ArrayList<Boolean>> getBooleanList(String key, ObjectResultCallback<ArrayList<Boolean>> callback) {
        return this.getList(this.context, key, callback);
    }

    public Context getContext() {
        return this.context;
    }

    public ObjectResult<Double> getDouble(String key, double defaultValue, ObjectResultCallback<Double> callback) {
        return this.get(this.context, key, defaultValue, Double.class, callback);
    }

    public ObjectResult<ArrayList<Double>> getDoubleList(String key, ObjectResultCallback<ArrayList<Double>> callback) {
        return this.getList(this.context, key, callback);
    }

    protected ExecutorService getExecutorService() {
        return this.executorService;
    }

    public ObjectResult<Integer> getInt(String key, int defaultValue, ObjectResultCallback<Integer> callback) {
        return this.get(this.context, key, defaultValue, Integer.class, callback);
    }

    public ObjectResult<ArrayList<Integer>> getIntList(String key, ObjectResultCallback<ArrayList<Integer>> callback) {
        return this.getList(this.context, key, callback);
    }

    public <T extends JsonParser> ObjectResult<T> getObject(String key, Class<T> clazz, ObjectResultCallback<T> callback) {
        return this.getJson(this.context, key, clazz, callback);
    }

    public <T extends JsonParser> ObjectResult<ArrayList<T>> getObjectList(String key, Class<T> clazz, ObjectResultCallback<ArrayList<T>> callback) {
        return this.getJsonList(this.context, key, clazz, callback);
    }

    public ObjectResult<String> getString(String key, String defaultValue, ObjectResultCallback<String> callback) {
        return this.get(this.context, key, defaultValue, String.class, callback);
    }

    public ObjectResult<ArrayList<String>> getStringList(String key, ObjectResultCallback<ArrayList<String>> callback) {
        return this.getList(this.context, key, callback);
    }

    public BasicResult putBoolean(String key, boolean value, BasicResultCallback callback) {
        return this.update(this.context, key, RequestBody.create((MediaType)MEDIA_TYPE_PLAIN, (String)Boolean.toString(value)), callback);
    }

    public BasicResult putBooleanList(String key, ArrayList<Boolean> values, BasicResultCallback callback) {
        return this.putInternalArrayList(key, values, callback);
    }

    public BasicResult putDouble(String key, double value, BasicResultCallback callback) {
        return this.update(this.context, key, RequestBody.create((MediaType)MEDIA_TYPE_PLAIN, (String)Double.toString(value)), callback);
    }

    public BasicResult putDoubleList(String key, ArrayList<Double> values, BasicResultCallback callback) {
        return this.putInternalArrayList(key, values, callback);
    }

    public BasicResult putInt(String key, int value, BasicResultCallback callback) {
        return this.update(this.context, key, RequestBody.create((MediaType)MEDIA_TYPE_PLAIN, (String)Integer.toString(value)), callback);
    }

    public BasicResult putIntList(String key, ArrayList<Integer> values, BasicResultCallback callback) {
        return this.putInternalArrayList(key, values, callback);
    }

    public BasicResult putObject(String key, JsonParser value, BasicResultCallback callback) {
        RequestBody json = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)value.toJson().toString());
        return this.update(this.context, key, json, callback);
    }

    public BasicResult putObjectList(String key, ArrayList<? extends JsonParser> values, BasicResultCallback callback) {
        JSONArray array = new JSONArray();
        for (JsonParser jsonParser : values) {
            array.put((Object)jsonParser.toJson());
        }
        RequestBody json = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)array.toString());
        return this.update(this.context, key, json, callback);
    }

    public BasicResult putString(String key, String value, BasicResultCallback callback) {
        return this.update(this.context, key, RequestBody.create((MediaType)MEDIA_TYPE_PLAIN, (String)value), callback);
    }

    public BasicResult putStringList(String key, ArrayList<String> values, BasicResultCallback callback) {
        return this.putInternalArrayList(key, values, callback);
    }

    public BasicResult remove(String key, BasicResultCallback callback) {
        return this.delete(this.context, key, callback);
    }

    protected BasicResult delete(final @NonNull Context context, final String key, BasicResultCallback callback) {
        final BasicResult request = new BasicResult(context, callback, this.executorService, this.handler);
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                String methodIdentifier = "UserPreference.clear";
                try {
                    Result deleteUserPref;
                    String url = FlybitsPreferences.API_USER_PREF;
                    if (key != null) {
                        url = url + "/" + key;
                    }
                    if ((deleteUserPref = FlyAway.delete(context, url, methodIdentifier, null)).getStatus() == RequestStatus.COMPLETED || deleteUserPref.getStatus() == RequestStatus.NOT_FOUND) {
                        request.setSuccess();
                    } else {
                        request.setResult(deleteUserPref);
                    }
                }
                catch (FlybitsException e) {
                    request.setFailed(e);
                }
            }
        });
        return request;
    }

    protected <T> ObjectResult<T> get(final @NonNull Context context, final String key, final T defaultValue, final Class<T> clazz, ObjectResultCallback<T> callback) {
        final ObjectResult<T> request = new ObjectResult<T>(context, callback, this.executorService, this.handler);
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = "/kernel/userpref/" + key;
                    String methodIdentifier = "UserPreference.get";
                    Result getUserPrefs = FlyAway.get(context, url, null, methodIdentifier, null);
                    if (getUserPrefs.getStatus() == RequestStatus.COMPLETED) {
                        String response = getUserPrefs.getResultAsString();
                        if (clazz.isAssignableFrom(String.class)) {
                            request.setSuccess(response);
                        } else if (clazz.isAssignableFrom(Integer.class)) {
                            request.setSuccess(Integer.valueOf(response));
                        } else if (clazz.isAssignableFrom(Boolean.class)) {
                            request.setSuccess(Boolean.valueOf(response));
                        } else if (clazz.isAssignableFrom(Double.class)) {
                            request.setSuccess(Double.valueOf(response));
                        } else {
                            request.setFailed(new FlybitsException("Unable to parse the JSON returned for the key: " + key));
                        }
                    } else if (getUserPrefs.getStatus() == RequestStatus.NOT_FOUND) {
                        request.setSuccess(defaultValue);
                    } else {
                        request.setResult(getUserPrefs);
                    }
                }
                catch (FlybitsException e) {
                    request.setFailed(e);
                }
            }
        });
        return request;
    }

    protected <T extends JsonParser> ObjectResult<T> getJson(final @NonNull Context context, final String key, final Class<T> clazz, ObjectResultCallback<T> callback) {
        final ObjectResult<T> request = new ObjectResult<T>(context, callback, this.executorService, this.handler);
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = "/kernel/userpref/" + key;
                    String methodIdentifier = "UserPreference.get";
                    Result getUserPrefs = FlyAway.get(context, url, null, methodIdentifier, null);
                    if (getUserPrefs.getStatus() == RequestStatus.COMPLETED) {
                        String response = getUserPrefs.getResultAsString();
                        try {
                            JsonParser newInstance = (JsonParser)clazz.newInstance();
                            newInstance.fromJson(response);
                            request.setSuccess(newInstance);
                        }
                        catch (ClassCastException | IllegalAccessException | InstantiationException ex) {
                            request.setFailed(new FlybitsException("Unable to parse the JSON based on the defined fromJSON(String) method"));
                        }
                    } else if (getUserPrefs.getStatus() == RequestStatus.NOT_FOUND) {
                        request.setSuccess(null);
                    } else {
                        request.setResult(getUserPrefs);
                    }
                }
                catch (FlybitsException e) {
                    request.setFailed(e);
                }
            }
        });
        return request;
    }

    protected <T extends JsonParser> ObjectResult<ArrayList<T>> getJsonList(final @NonNull Context context, final String key, final Class<T> clazz, ObjectResultCallback<ArrayList<T>> callback) {
        final ObjectResult<ArrayList<T>> request = new ObjectResult<ArrayList<T>>(context, callback, this.executorService, this.handler);
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = "/kernel/userpref/" + key;
                    String methodIdentifier = "UserPreference.get";
                    Result getUserPrefs = FlyAway.get(context, url, null, methodIdentifier, null);
                    if (getUserPrefs.getStatus() == RequestStatus.COMPLETED) {
                        String response = getUserPrefs.getResultAsString();
                        try {
                            ArrayList<JsonParser> listOfObjects = new ArrayList<JsonParser>();
                            JSONArray array = new JSONArray(response);
                            for (int i = 0; i < array.length(); ++i) {
                                JsonParser newInstance = (JsonParser)clazz.newInstance();
                                newInstance.fromJson(array.getJSONObject(i).toString());
                                listOfObjects.add(newInstance);
                            }
                            request.setSuccess(listOfObjects);
                        }
                        catch (ClassCastException | IllegalAccessException | InstantiationException | JSONException ex) {
                            request.setFailed(new FlybitsException("Unable to parse the JSON based on the defined fromJSON(String) method"));
                        }
                    } else if (getUserPrefs.getStatus() == RequestStatus.NOT_FOUND) {
                        request.setSuccess(new ArrayList());
                    } else {
                        request.setResult(getUserPrefs);
                    }
                }
                catch (FlybitsException e) {
                    request.setFailed(e);
                }
            }
        });
        return request;
    }

    protected <T> ObjectResult<ArrayList<T>> getList(final @NonNull Context context, final String key, ObjectResultCallback<ArrayList<T>> callback) {
        final ObjectResult<ArrayList<T>> request = new ObjectResult<ArrayList<T>>(context, callback, this.executorService, this.handler);
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = "/kernel/userpref/" + key;
                    String methodIdentifier = "UserPreference.get";
                    Result getUserPrefs = FlyAway.get(context, url, null, methodIdentifier, null);
                    if (getUserPrefs.getStatus() == RequestStatus.COMPLETED) {
                        String response = getUserPrefs.getResultAsString();
                        try {
                            JSONArray jsonArray = new JSONArray(response);
                            ArrayList<Object> listOfItems = new ArrayList<Object>();
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                listOfItems.add(jsonArray.get(i));
                            }
                            request.setSuccess(listOfItems);
                        }
                        catch (ClassCastException | JSONException ex) {
                            request.setFailed(new FlybitsException("Unable to parse the JSON based on the defined fromJSON(String) method"));
                        }
                    } else if (getUserPrefs.getStatus() == RequestStatus.NOT_FOUND) {
                        request.setSuccess(new ArrayList());
                    } else {
                        request.setResult(getUserPrefs);
                    }
                }
                catch (FlybitsException e) {
                    request.setFailed(e);
                }
            }
        });
        return request;
    }

    protected <T> BasicResult putInternalArrayList(String key, ArrayList<T> values, BasicResultCallback callback) {
        JSONArray jsonArray = new JSONArray();
        for (T value : values) {
            jsonArray.put(value);
        }
        return this.update(this.context, key, jsonArray, callback);
    }

    protected BasicResult update(final @NonNull Context context, final String key, final RequestBody value, BasicResultCallback callback) {
        final BasicResult request = new BasicResult(context, callback, this.executorService, this.handler);
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                block6: {
                    String methodIdentifier = "UserPreference.update";
                    String url = "/kernel/userpref/" + key;
                    try {
                        Result putUserPrefs = FlyAway.put(context, url, value, null, methodIdentifier, null);
                        if (putUserPrefs.getStatus() == RequestStatus.NOT_FOUND) {
                            Result createUserPrefs = FlyAway.post(context, url, value, null, methodIdentifier, null);
                            if (createUserPrefs.getStatus() == RequestStatus.NOT_FOUND) {
                                JSONObject rootObject = new JSONObject();
                                try {
                                    rootObject.put("data", (Object)value);
                                }
                                catch (JSONException jSONException) {
                                    // empty catch block
                                }
                                String body = rootObject.toString();
                                Result createRootUserPrefs = FlyAway.post(context, FlybitsPreferences.API_USER_PREF, body, null, methodIdentifier, null);
                                request.setResult(createRootUserPrefs);
                                break block6;
                            }
                            request.setResult(createUserPrefs);
                            break block6;
                        }
                        request.setResult(putUserPrefs);
                    }
                    catch (FlybitsException e) {
                        request.setFailed(e);
                    }
                }
            }
        });
        return request;
    }

    protected BasicResult update(final @NonNull Context context, final String key, final JSONArray value, BasicResultCallback callback) {
        final BasicResult request = new BasicResult(context, callback, this.executorService, this.handler);
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                block6: {
                    String methodIdentifier = "UserPreference.update";
                    String url = "/kernel/userpref/" + key;
                    try {
                        Result putUserPrefs = FlyAway.put(context, url, value.toString(), null, methodIdentifier, null);
                        if (putUserPrefs.getStatus() == RequestStatus.NOT_FOUND) {
                            Result createUserPrefs = FlyAway.post(context, url, value.toString(), null, methodIdentifier, null);
                            if (createUserPrefs.getStatus() == RequestStatus.NOT_FOUND) {
                                JSONObject rootObject = new JSONObject();
                                try {
                                    JSONObject object = new JSONObject();
                                    object.put(key, (Object)value);
                                    rootObject.put("data", (Object)object);
                                }
                                catch (JSONException object) {
                                    // empty catch block
                                }
                                String body = rootObject.toString();
                                Result createRootUserPrefs = FlyAway.post(context, FlybitsPreferences.API_USER_PREF, body, null, methodIdentifier, null);
                                request.setResult(createRootUserPrefs);
                                break block6;
                            }
                            request.setResult(createUserPrefs);
                            break block6;
                        }
                        request.setResult(putUserPrefs);
                    }
                    catch (FlybitsException e) {
                        request.setFailed(e);
                    }
                }
            }
        });
        return request;
    }
}

