/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.internal.models.preferences;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.models.Preference;
import com.flybits.internal.models.preferences.FlybitsPreferences;
import java.util.ArrayList;
import java.util.List;

public class Favourite
extends FlybitsPreferences {
    public Favourite(Context context) {
        super(context, new Handler(Looper.getMainLooper()));
    }

    public Favourite(Context context, Handler handler) {
        super(context, handler);
    }

    public void add(final String key, final String value, final BasicResultCallback callback) {
        this.getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                Preference preference = new Preference(key, value);
                CommonsDatabase.getDatabase(Favourite.this.getContext()).preferenceDAO().insert(preference);
                List<String> listOfItemsSaved = CommonsDatabase.getDatabase(Favourite.this.getContext()).preferenceDAO().getIdsByKey(key);
                if (callback != null && listOfItemsSaved != null && listOfItemsSaved.size() > 0) {
                    Favourite.this.putStringList(key, (ArrayList)listOfItemsSaved, callback);
                }
            }
        });
    }

    public void remove(final String key, final String value, final BasicResultCallback callback) {
        this.getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                CommonsDatabase.getDatabase(Favourite.this.getContext()).preferenceDAO().deleteByKeyAndValue(key, value);
                List<String> listOfItemsSaved = CommonsDatabase.getDatabase(Favourite.this.getContext()).preferenceDAO().getIdsByKey(key);
                if (callback != null && listOfItemsSaved != null && listOfItemsSaved.size() > 0) {
                    Favourite.this.putStringList(key, (ArrayList)listOfItemsSaved, callback);
                }
            }
        });
    }

    public void containsDB(final String key, final String value, final @NonNull ObjectResultCallback<Boolean> callback) {
        this.getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                if (callback != null) {
                    List<Preference> items = CommonsDatabase.getDatabase(Favourite.this.getContext()).preferenceDAO().getIdsByKeyAndValue(key, value);
                    callback.onSuccess(items.size() > 0);
                }
            }
        });
    }

    public void getFromDB(final String key, final @NonNull ObjectResultCallback<List<String>> callback) {
        this.getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                if (callback != null) {
                    List<String> items = CommonsDatabase.getDatabase(Favourite.this.getContext()).preferenceDAO().getIdsByKey(key);
                    callback.onSuccess(items);
                }
            }
        });
    }

    public void getFromServer(String key, @NonNull ObjectResultCallback<ArrayList<String>> callback) {
        this.getStringList(key, callback);
    }
}

