/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.internal.db;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.room.Database;
import android.arch.persistence.room.Room;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.migration.Migration;
import android.content.Context;
import com.flybits.commons.library.models.User;
import com.flybits.internal.db.CachingEntryDAO;
import com.flybits.internal.db.PreferenceDAO;
import com.flybits.internal.db.UserDAO;
import com.flybits.internal.db.models.CachingEntry;
import com.flybits.internal.db.models.Preference;

@Database(entities={User.class, CachingEntry.class, Preference.class}, version=4)
public abstract class CommonsDatabase
extends RoomDatabase {
    private static CommonsDatabase INSTANCE;
    public static final Migration MIGRATION_1_4;
    static final Migration MIGRATION_2_4;
    static final Migration MIGRATION_3_4;

    public abstract UserDAO userDao();

    public abstract CachingEntryDAO cachingEntryDAO();

    public abstract PreferenceDAO preferenceDAO();

    public static CommonsDatabase getDatabase(Context context) {
        if (INSTANCE == null) {
            INSTANCE = (CommonsDatabase)Room.databaseBuilder((Context)context, CommonsDatabase.class, (String)"commons-flybits-db").addMigrations(new Migration[]{MIGRATION_1_4}).addMigrations(new Migration[]{MIGRATION_2_4}).addMigrations(new Migration[]{MIGRATION_3_4}).fallbackToDestructiveMigration().build();
        }
        return INSTANCE;
    }

    public static void destroyInstance() {
        INSTANCE = null;
    }

    static {
        MIGRATION_1_4 = new Migration(1, 4){

            public void migrate(SupportSQLiteDatabase database) {
                database.execSQL("ALTER TABLE user ADD isVerified INTEGER NOT NULL DEFAULT 0");
                database.execSQL("DROP TABLE IF EXISTS cachingentry");
                database.execSQL("CREATE TABLE cachingentry (sequence INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, cachingkey TEXT NOT NULL, contentID TEXT NOT NULL)");
                database.execSQL("CREATE UNIQUE INDEX index_cachingentry_cachingkey_contentID on cachingentry (cachingkey, contentID)");
                database.execSQL("CREATE TABLE preferences (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, prefKey TEXT NOT NULL, value TEXT NOT NULL)");
            }
        };
        MIGRATION_2_4 = new Migration(2, 4){

            public void migrate(SupportSQLiteDatabase database) {
                database.execSQL("DROP TABLE IF EXISTS cachingentry");
                database.execSQL("CREATE TABLE cachingentry (sequence INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, cachingkey TEXT NOT NULL, contentID TEXT NOT NULL)");
                database.execSQL("CREATE UNIQUE INDEX index_cachingentry_cachingkey_contentID on cachingentry (cachingkey, contentID)");
                database.execSQL("CREATE TABLE preferences (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, prefKey TEXT NOT NULL, value TEXT NOT NULL)");
            }
        };
        MIGRATION_3_4 = new Migration(3, 4){

            public void migrate(SupportSQLiteDatabase database) {
                database.execSQL("CREATE TABLE preferences (id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, prefKey TEXT NOT NULL, value TEXT NOT NULL)");
            }
        };
    }
}

