/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.caching;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.Observer;
import android.support.annotation.Nullable;

public abstract class FlybitsUIObjectObserver<T> {
    private DataChanged<T> callback;
    private LiveData<T> item;
    private Observer<T> observer;

    public void add(DataChanged<T> callback) {
        this.callback = callback;
    }

    @Nullable
    public LiveData<T> getData() {
        return this.item;
    }

    public void remove() {
        if (this.item != null && this.item.hasActiveObservers()) {
            this.item.removeObserver(this.observer);
        }
    }

    public void setItem(LiveData<T> item) {
        this.item = item;
        this.observer = new Observer<T>(){

            public void onChanged(@Nullable T t) {
                if (FlybitsUIObjectObserver.this.callback != null) {
                    FlybitsUIObjectObserver.this.callback.onUpdate(t);
                }
            }
        };
        this.item.observeForever(this.observer);
    }

    public static interface DataChanged<T> {
        public void onUpdate(T var1);
    }
}

