/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api.results;

import android.content.Context;
import android.support.annotation.NonNull;
import com.flybits.commons.library.api.results.FlybitsResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.internal.Result;
import java.util.concurrent.ExecutorService;

public class BasicResult
extends FlybitsResult {
    private BasicResultCallback callback;

    public BasicResult(@NonNull Context context, BasicResultCallback callback) {
        super(context);
        this.callback = callback;
    }

    public BasicResult(@NonNull Context context, BasicResultCallback callback, @NonNull ExecutorService service) {
        super(context, service);
        this.callback = callback;
    }

    @Override
    public boolean setFailed(FlybitsException e) {
        if (super.setFailed(e)) {
            if (this.callback != null) {
                this.callback.onException(e);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean setSuccess() {
        if (super.setSuccess()) {
            if (this.callback != null) {
                this.callback.onSuccess();
            }
            return true;
        }
        return false;
    }

    public void setResult(@NonNull Result result) {
        if (result.getStatus() == RequestStatus.COMPLETED) {
            this.setSuccess();
        } else {
            this.setFailed(result.getException());
        }
    }
}

