package com.flybits.concierge.smartrewards.model;

import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.os.Parcel;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.models.BaseTemplate;
import com.flybits.concierge.smartrewards.utils.ColorHelper;

import java.util.List;

public class Benefit extends BaseTemplate {

    public LocalizedValue title;
    public LocalizedValue explanation;
    public String sourceImage;
    public String source;
    public String header;
    public List<String> gradient;
    public String backgroundColor;
    public String url;
    public ActionButton primaryButton;

    private GradientDrawable gradientDrawable;
    private boolean expanded;

    public Benefit() {
        // required
    }

    public Benefit(Parcel in) {
        super(in);
        title = in.readParcelable(LocalizedValue.class.getClassLoader());
        explanation = in.readParcelable(LocalizedValue.class.getClassLoader());
        sourceImage = in.readString();
        source = in.readString();
        header = in.readString();
        backgroundColor = in.readString();
        gradient = in.createStringArrayList();
        url = in.readString();
        primaryButton = in.readParcelable(ActionButton.class.getClassLoader());
    }

    public int getColor() {
        return backgroundColor != null ? Color.parseColor(backgroundColor) : Color.WHITE;
    }

    public GradientDrawable getGradientDrawable() {

        if (gradient == null || gradient.size() < 2) {
            return null;
        } else if (gradientDrawable != null) {
            return gradientDrawable;
        }

        gradientDrawable = ColorHelper.INSTANCE.generateGradientDrawable(gradient);

        return gradientDrawable;
    }

    public boolean isExpanded() {
        return expanded;
    }

    public void setExpanded(boolean expand) {
        expanded = expand;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);

        dest.writeParcelable(title, flags);
        dest.writeParcelable(explanation, flags);
        dest.writeString(sourceImage);
        dest.writeString(source);
        dest.writeString(header);
        dest.writeString(backgroundColor);
        dest.writeStringList(gradient);
        dest.writeString(url);
        dest.writeParcelable(primaryButton, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<Benefit> CREATOR = new Creator<Benefit>()
    {
        @Override
        public Benefit createFromParcel(Parcel in)
        {
            return new Benefit(in);
        }

        @Override
        public Benefit[] newArray(int size)
        {
            return new Benefit[size];
        }
    };
}
