package com.flybits.concierge.smartrewards.utils

import android.graphics.Color
import android.graphics.drawable.GradientDrawable
import com.flybits.commons.library.logging.Logger
import java.lang.IllegalArgumentException

object ColorHelper {
    fun generateGradientDrawable(gradient: List<String>) : GradientDrawable {

        if (gradient.isEmpty()) {
            throw IllegalArgumentException("Number of colors must be greater than 1.")
        }

        val colors = IntArray(gradient.size) // build an array of ints

        for (i in gradient.indices) {
            try {
                colors[i] = Color.parseColor(gradient[i]) // populate array with android colors
            } catch (e: IllegalArgumentException){
                Logger.e("generateGradientDrawable : Invalid Color, please provide in valid hex format (eg: #000000)")
            }
        }

        return GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, colors) // generate GradientDrawable object
    }

    fun defaultBackgroundColor() : Int = Color.WHITE
}