package com.flybits.concierge.smartrewards.activities

import android.content.Intent
import android.os.Bundle
import androidx.fragment.app.Fragment
import androidx.core.content.ContextCompat
import com.flybits.concierge.activities.SingleFragmentActivity
import com.flybits.concierge.smartrewards.R
import com.flybits.concierge.smartrewards.fragments.OfferFragment
import kotlinx.android.synthetic.main.smartrewards_activity_offer.*


class OfferActivity : SingleFragmentActivity() {

    companion object {
        const val EXTRA_OFFER_DETAILS = "flybits_con_extra_offer_details"
        const val EXTRA_USER_ACTION_HANDLER = "flybits_con_extra_user_action_handler"
    }

    override fun onCreateSingleContentActivity(intent: Intent): Fragment {
        return OfferFragment.newInstance(
            intent.getParcelableExtra(EXTRA_OFFER_DETAILS)
            , intent.getParcelableExtra(EXTRA_USER_ACTION_HANDLER)
        )
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.smartrewards_activity_offer)
        // add custom back button
        setSupportActionBar(toolbar)
        toolbar.navigationIcon = ContextCompat.getDrawable(this, R.drawable.ic_back_outline)
    }
}
