package com.flybits.concierge.smartrewards.model

/**
 * Enum class representing different types of user engagements with OptIn Content type
 *
 * string value for each enum type is useful in storing it in SharedPreferences and must be
 * kept the same as the enum type
 */
enum class OptInInteraction(val string: String) {

    NOT_ENGAGED("not_engaged"),             // User did not interact with OptIn Card
    ENGAGED_ACCEPTED("engaged_accepted"),   // User clicked on Accept button
    ENGAGED_DECLINED("engaged_declined")    // User clicked on Reject/Decline button
}