package com.flybits.concierge.smartrewards.fragments


import android.os.Bundle
import android.support.design.widget.Snackbar
import android.support.v4.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.bumptech.glide.request.RequestOptions
import com.flybits.android.kernel.ContentAnalytics
import com.flybits.concierge.FlybitsNavigator

import com.flybits.concierge.smartrewards.R
import com.flybits.concierge.smartrewards.model.Offer

private const val ARG_OFFER = "arg_offer"

class OfferFragment : Fragment() {
    private var offer: Offer? = null
    private var contentAnalytics:ContentAnalytics? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            offer = it.getParcelable(ARG_OFFER)
        }
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.smartrewards_fragment_offer, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        val bannerView : ImageView = view.findViewById(R.id.smartrewards_fragment_template_offer_banner)
        val headerView : TextView = view.findViewById(R.id.smartrewards_fragment_template_offer_header)
        val titleView : TextView = view.findViewById(R.id.smartrewards_fragment_template_offer_title)
        val descriptionView : TextView = view.findViewById(R.id.smartrewards_fragment_template_offer_description)
        val primaryButton : TextView = view.findViewById(R.id.smartrewards_fragment_template_offer_primary_btn)
        val secondaryButton : TextView = view.findViewById(R.id.smartrewards_fragment_template_offer_secondary_btn)
        val subtitleView : TextView = view.findViewById(R.id.smartrewards_fragment_template_offer_subtitle)

        titleView.visibility = View.GONE
        descriptionView.visibility = View.GONE
        subtitleView.visibility = View.GONE

        primaryButton.visibility = View.GONE
        secondaryButton.visibility = View.GONE

        contentAnalytics = context?.let { ContentAnalytics(it) }

        offer?.let {

            bannerView.setImageResource(android.R.drawable.ic_menu_gallery)
            it.banner?.let { url ->
                Glide.with(view.context).load(url).apply(RequestOptions().centerCrop()).into(bannerView)
            }

            headerView.text = it.header?.value ?: "" // required

            it.title?.let { titleView.visibility = View.VISIBLE }
            it.explanation?.let { descriptionView.visibility = View.VISIBLE }
            it.subtitle?.let { subtitleView.visibility = View.VISIBLE }

            titleView.text = it.title?.value
            descriptionView.text = it.explanation?.value
            subtitleView.text = it.subtitle?.value


            val primaryURL = offer?.primaryButton?.actionURL
            if (primaryURL == null){
                //Don't show button if primary button URL is null
                primaryButton.visibility = View.GONE
            } else {
                it.primaryButton?.let { button ->
                    primaryButton.visibility = View.VISIBLE
                    primaryButton.text = button.label?.value ?: ""
                    primaryButton.setBackgroundColor(button.getColor())
                    primaryButton.setOnClickListener {
                        offer?.content?.let { content -> contentAnalytics?.trackFulfilled(content) } // Full-filled analytics when clicked Accept.
                        val success = (activity as FlybitsNavigator?)?.openUrl(primaryURL)
                        if (success == false){
                            Snackbar.make(view, getString(R.string.flybits_con_generic_error), Snackbar.LENGTH_SHORT).show()
                        }

                    }
                }
            }

        it.secondaryButton?.let { button ->
                secondaryButton.visibility = View.VISIBLE
                secondaryButton.text = button.label?.value
                secondaryButton.setTextColor(button.getColor())
                secondaryButton.setOnClickListener {
                    button.actionURL?.let { secondaryActionURL ->
                        if (secondaryActionURL.isEmpty()){
                            //Close activity if URL is empty
                            activity?.finish()
                        } else {
                            (activity as FlybitsNavigator?)?.openUrl(secondaryActionURL)
                        }
                    } ?: activity?.finish()
                }
            }
        }

    }

    companion object {
        @JvmStatic
        fun newInstance(offer: Offer) =
            OfferFragment().apply {
                arguments = Bundle().apply {
                    putParcelable(ARG_OFFER, offer)
                }
            }
    }
}
