package com.flybits.concierge.smartrewards

import android.content.Context
import android.content.SharedPreferences

object InternalPreferences {

    private const val PREFS_NAME : String = "SmartRewardsConciergePrefs"
    private const val ENGAGED_SET_NAME : String = "SmartRewardsEngagedSet"

    private fun getInstance(context: Context) : SharedPreferences = context.getSharedPreferences(PREFS_NAME, Context.MODE_PRIVATE)
    private fun getSaveInstance(context: Context) : SharedPreferences.Editor = getInstance(context).edit()
    private fun getEngaged(context: Context) = getInstance(context).getStringSet(ENGAGED_SET_NAME, HashSet<String>())

    fun isContentEngaged(context: Context, contentId: String) : Boolean {
        val engaged = getEngaged(context)

        engaged?.let {
            return@isContentEngaged it.contains(contentId)
        }

        return false
    }

    fun engageContent(context: Context, contentId : String) {
        val contentSet = getEngaged(context)
        contentSet?.let {
            it.add(contentId)
            getSaveInstance(context).putStringSet(ENGAGED_SET_NAME, it).apply()
        }
    }
}