package com.flybits.concierge.smartrewards.viewproviders

import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.support.v7.widget.LinearLayoutManager
import android.support.v7.widget.PagerSnapHelper
import android.support.v7.widget.RecyclerView
import android.text.TextUtils
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.FlybitsViewProvider
import com.flybits.concierge.smartrewards.R
import com.flybits.concierge.smartrewards.activities.OfferActivity
import com.flybits.concierge.smartrewards.model.Benefit
import com.flybits.concierge.smartrewards.model.Benefits
import com.flybits.concierge.smartrewards.utils.ViewHelper
import com.flybits.concierge.smartrewards.views.RoundedCornerBorderButton
import com.flybits.concierge.viewholders.FlybitsViewHolder


class BenefitsViewProvider : FlybitsViewProvider <Benefits> {
    override fun getClassType(): Class<Benefits> {
        return Benefits::class.java
    }

    override fun getContentType(): String {
        return "ctn-flybits-benefits-card"
    }

    override fun onCreateViewHolder(parent: ViewGroup): FlybitsViewHolder<Benefits> {
        return BenefitsViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.smartrewards_item_template_benefits, parent, false))
    }

    override fun onPushOpened(model: Benefits, flybitsNavigator: FlybitsNavigator) {
    }

    companion object {
        private fun configureView(data: Benefit, benefitView: View) {
            val gradientView: View = benefitView.findViewById(R.id.smartrewards_benefit_gradient)
            val headerTextView: TextView = benefitView.findViewById(R.id.smartrewards_benefit_header)
            val titleTextView: TextView = benefitView.findViewById(R.id.smartrewards_benefit_title)
            val descriptionTextView: TextView = benefitView.findViewById(R.id.smartrewards_benefit_description)
            val sourceTextView: TextView = benefitView.findViewById(R.id.smartrewards_benefit_source)
            val sourceImageView: ImageView = benefitView.findViewById(R.id.smartrewards_benefit_sourceImg)
            val primaryButton: RoundedCornerBorderButton = benefitView.findViewById(R.id.smartrewards_benefit_primaryBtn)

            gradientView.background = data.gradientDrawable

            if (!TextUtils.isEmpty(data.header)) {
                headerTextView.visibility = View.VISIBLE
                headerTextView.text = data.header
            } else {
                headerTextView.visibility = View.GONE
            }

            titleTextView.text = data.title.value // required

            descriptionTextView.text = data.explanation.value

            primaryButton.visibility = View.INVISIBLE
            if (data.primaryButton != null
                && data.primaryButton.label != null
                && !TextUtils.isEmpty(data.primaryButton.label.value)
                && !TextUtils.isEmpty(data.primaryButton.actionURL)) {
                primaryButton.visibility = View.VISIBLE

                primaryButton.setText(data.primaryButton.label.value)
                primaryButton.setColor(data.primaryButton.getColor())

                primaryButton.setOnClickListener {
                    val intent = Intent(Intent.ACTION_VIEW)
                    intent.data = Uri.parse(data.primaryButton.actionURL)
                    benefitView.context.startActivity(intent)
                }
            }

            sourceTextView.text = data.source

            if (!TextUtils.isEmpty(data.sourceImage)) {
                sourceImageView.visibility = View.VISIBLE
                Glide.with(sourceImageView.context)
                    .load(data.sourceImage)
                    .into(sourceImageView)
            } else {
                sourceImageView.visibility = View.GONE
            }
        }
    }

    // View Holder for the Benefit Card
    class BenefitsViewHolder (val view: View) : FlybitsViewHolder<Benefits>(view) {

        private val recycler : RecyclerView = view.findViewById(R.id.smartrewards_item_template_benefits_recyclerView)
        private val single : View = view.findViewById(R.id.smartrewards_item_template_benefits_single)
        private val emptyView : View = view.findViewById(R.id.smartrewards_item_template_benefits_emptyTxt)

        override fun bindData(data: Benefits, flybitsNavigator: FlybitsNavigator) {

            recycler.visibility = View.GONE
            single.visibility = View.GONE
            emptyView.visibility = View.GONE

            when (data.benefits.size) {
                0 -> {
                    emptyView.visibility = View.VISIBLE
                }
                1 -> { // single view
                    single.visibility = View.VISIBLE
                    configureView(data.benefits[0], view)
                }
                else -> { // multi view
                    recycler.visibility = View.VISIBLE
                    recycler.layoutManager = LinearLayoutManager(recycler.context, LinearLayoutManager.HORIZONTAL, false)
                    recycler.adapter = BenefitRecyclerAdapter(data.benefits)
                    recycler.onFlingListener = null // need to unset the fling listener. platform bug
                    val snapHelper = PagerSnapHelper()
                    snapHelper.attachToRecyclerView(recycler)
                }
            }
        }
    }

    class BenefitRecyclerAdapter(val benefits: List<Benefit>) : RecyclerView.Adapter<BenefitRecyclerAdapter.ViewHolder>() {

        class ViewHolder(val view: View) : RecyclerView.ViewHolder (view) {
            init {
                view.layoutParams.width = ViewHelper.cardPeekWidth(view.context)
            }
        }

        override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): BenefitRecyclerAdapter.ViewHolder {
            return BenefitRecyclerAdapter.ViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.smartrewards_item_template_benefit, parent, false))
        }

        override fun getItemCount(): Int {
            return benefits.size
        }

        override fun onBindViewHolder(holder: ViewHolder, position: Int) {
            configureView(benefits[position], holder.view)
        }
    }
}