package com.flybits.concierge.smartrewards.model;

import android.graphics.Color;
import android.os.Parcel;
import android.text.TextUtils;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.models.BaseTemplate;

public class ActionButton extends BaseTemplate {

    public LocalizedValue label;
    public String color;
    public String actionURL;


    public ActionButton() {

    }

    public ActionButton(Parcel in) {
        super(in);
        label = in.readParcelable(LocalizedValue.class.getClassLoader());
        color = in.readString();
        actionURL = in.readString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);

        dest.writeParcelable(label, flags);
        dest.writeString(color);
        dest.writeString(actionURL);
    }

    public int getColor() {
        return !TextUtils.isEmpty(color) ? Color.parseColor(color) : Color.BLACK;
    }

    public static final Creator<ActionButton> CREATOR = new Creator<ActionButton>()
    {
        @Override
        public ActionButton createFromParcel(Parcel in)
        {
            return new ActionButton(in);
        }

        @Override
        public ActionButton[] newArray(int size)
        {
            return new ActionButton[size];
        }
    };
}