package com.flybits.concierge.smartrewards.activities

import android.os.Bundle
import android.support.v4.content.ContextCompat
import android.support.v7.app.AppCompatActivity
import android.view.MenuItem
import com.flybits.concierge.smartrewards.R
import com.flybits.concierge.smartrewards.fragments.OfferFragment
import com.flybits.concierge.smartrewards.model.Offer
import kotlinx.android.synthetic.main.smartrewards_activity_offer.*


class OfferActivity : AppCompatActivity() {

    companion object {
        const val EXTRA_OFFER_DETAILS = "flybits_con_extra_offer_details"
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.smartrewards_activity_offer)
        setSupportActionBar(toolbar)

        supportActionBar!!.setDisplayHomeAsUpEnabled(true)
        supportActionBar!!.setDisplayShowHomeEnabled(true)

        // add custom back button
        toolbar.navigationIcon = ContextCompat.getDrawable(this, R.drawable.ic_back_outline)

        val offer = intent.extras!!.getParcelable<Offer>(EXTRA_OFFER_DETAILS)

        if (savedInstanceState == null) {
            // add the Offer Fragment
            offer?.let {
                val offerFragment = OfferFragment.newInstance(it)
                supportFragmentManager.beginTransaction()
                    .add(R.id.smartrewards_content_container, offerFragment)
                    .commit()
            }
        }
    }

    override fun onOptionsItemSelected(item: MenuItem?): Boolean {
        // handle the navigation back button press
        if (item!!.itemId == android.R.id.home) {
            finish()
            return true
        }

        return super.onOptionsItemSelected(item)
    }
}
