/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.smartrewards.model;

import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.models.BaseTemplate;

public class ActionButton
extends BaseTemplate {
    public LocalizedValue label;
    public String color;
    public String actionURL;
    public static final Parcelable.Creator<ActionButton> CREATOR = new Parcelable.Creator<ActionButton>(){

        public ActionButton createFromParcel(Parcel in) {
            return new ActionButton(in);
        }

        public ActionButton[] newArray(int size) {
            return new ActionButton[size];
        }
    };

    public ActionButton() {
    }

    public ActionButton(Parcel in) {
        super(in);
        this.label = (LocalizedValue)in.readParcelable(LocalizedValue.class.getClassLoader());
        this.color = in.readString();
        this.actionURL = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)this.label, flags);
        dest.writeString(this.color);
        dest.writeString(this.actionURL);
    }

    public int getColor() {
        return !TextUtils.isEmpty((CharSequence)this.color) ? Color.parseColor((String)this.color) : -16777216;
    }

    public Drawable getBackgroundDrawable() {
        float[] radii = new float[8];
        for (int i = 0; i < radii.length; ++i) {
            radii[i] = 30.0f;
        }
        ShapeDrawable borderDrawable = new ShapeDrawable((Shape)new RoundRectShape(radii, null, radii));
        borderDrawable.getPaint().setColor(this.getColor());
        borderDrawable.getPaint().setStyle(Paint.Style.FILL);
        borderDrawable.setPadding(5, 5, 5, 5);
        ShapeDrawable backgroundShape = new ShapeDrawable((Shape)new RoundRectShape(radii, null, radii));
        backgroundShape.getPaint().setColor(Color.parseColor((String)"#FFFFFFFF"));
        backgroundShape.getPaint().setStyle(Paint.Style.FILL);
        backgroundShape.getPaint().setAntiAlias(true);
        Drawable[] drawables = new Drawable[]{borderDrawable, backgroundShape};
        backgroundShape.setPadding(50, 50, 50, 50);
        return new LayerDrawable(drawables);
    }
}

