package com.flybits.concierge.smartrewards.model;

import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.os.Parcel;
import android.text.TextUtils;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.models.BaseTemplate;

public class ActionButton extends BaseTemplate {

    public LocalizedValue label;
    public String color;
    public String actionURL;


    public ActionButton() {

    }

    public ActionButton(Parcel in) {
        super(in);
        label = in.readParcelable(LocalizedValue.class.getClassLoader());
        color = in.readString();
        actionURL = in.readString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);

        dest.writeParcelable(label, flags);
        dest.writeString(color);
        dest.writeString(actionURL);
    }

    public int getColor() {
        return !TextUtils.isEmpty(color) ? Color.parseColor(color) : Color.BLACK;
    }

    public Drawable getBackgroundDrawable() {

        float[] radii = new float[8];
        for (int i = 0; i < radii.length; i++) {
            radii[i] = 30;
        }

        // Set the shape border
        ShapeDrawable borderDrawable = new ShapeDrawable(new RoundRectShape(
                radii,
                null, // Inset
                radii
        ));
        borderDrawable.getPaint().setColor(getColor());
        borderDrawable.getPaint().setStyle(Paint.Style.FILL);
        // Define the border width
        borderDrawable.setPadding(5,5,5,5);

        // Set the shape background
        ShapeDrawable backgroundShape = new ShapeDrawable(new RoundRectShape(
                radii,
                null,
                radii
        ));
        backgroundShape.getPaint().setColor(Color.parseColor("#FFFFFFFF")); // background color
        backgroundShape.getPaint().setStyle(Paint.Style.FILL); // Define background
        backgroundShape.getPaint().setAntiAlias(true);

        // Initialize an array of drawables
        Drawable[] drawables = new Drawable[]{
                borderDrawable,
                backgroundShape
        };

        // Set shape padding
        backgroundShape.setPadding(50,50,50,50);

        // Finally, set the button background drawable
        return new LayerDrawable(drawables);
    }

    public static final Creator<ActionButton> CREATOR = new Creator<ActionButton>()
    {
        @Override
        public ActionButton createFromParcel(Parcel in)
        {
            return new ActionButton(in);
        }

        @Override
        public ActionButton[] newArray(int size)
        {
            return new ActionButton[size];
        }
    };
}