/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.http;

import android.content.Context;
import android.content.SharedPreferences;
import com.flybits.commons.library.FlyingConstants;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.api.FlybitsAPIConstants;
import com.flybits.commons.library.http.SerializableHttpCookie;
import com.flybits.commons.library.logging.LogType;
import com.flybits.commons.library.logging.Logger;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PersistentCookieStore
implements CookieStore {
    private SharedPreferences a;
    private static String b;
    private static String c;
    private Map<URI, Set<HttpCookie>> d;
    private Context e;
    private final String f = "Flybits-Cookies";

    public PersistentCookieStore(Context context) {
        this.e = context;
        b = FlybitsAPIConstants.getURI() + "/" + "|" + "FlybitsSession";
        c = FlybitsAPIConstants.getURI() + "/" + "|" + "_rememberMe";
        this.a = SharedElements.getPreferences(context);
        this.d = new HashMap<URI, Set<HttpCookie>>();
    }

    @Override
    public synchronized void add(URI uri, HttpCookie cookie) {
        Logger.instance(FlyingConstants.IS_DEBUG)._LOG("Flybits-Cookies", "Adding Cookie:", LogType.DEBUG);
        uri = PersistentCookieStore.a(uri, cookie);
        Set<HttpCookie> set = this.d.get(uri);
        if (set == null) {
            set = new HashSet<HttpCookie>();
            this.d.put(uri, set);
        }
        set.remove(cookie);
        set.add(cookie);
        Logger.instance(FlyingConstants.IS_DEBUG)._LOG("Flybits-Cookies", cookie.getName() + " : " + cookie.getValue(), LogType.DEBUG);
        Logger.instance(FlyingConstants.IS_DEBUG)._LOG("Flybits-Cookies", "---------------------------------", LogType.DEBUG);
        this.b(uri, cookie);
    }

    private static URI a(URI uRI, HttpCookie httpCookie) {
        URI uRI2 = uRI;
        if (httpCookie.getDomain() != null) {
            String string = httpCookie.getDomain();
            if (string.charAt(0) == '.') {
                string = string.substring(1);
            }
            try {
                uRI2 = new URI(uRI.getScheme() == null ? "http" : uRI.getScheme(), string, httpCookie.getPath() == null ? "/" : httpCookie.getPath(), null);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return uRI2;
    }

    private void b(URI uRI, HttpCookie httpCookie) {
        SharedPreferences.Editor editor = this.a.edit();
        editor.putString(uRI.toString() + "|" + httpCookie.getName(), new SerializableHttpCookie().encode(httpCookie));
        editor.apply();
    }

    public boolean isSessionSaved() {
        Map map = this.a.getAll();
        return map.containsKey(b) && map.containsKey(c);
    }

    @Override
    public synchronized List<HttpCookie> get(URI uri) {
        return this.a(uri);
    }

    @Override
    public synchronized List<HttpCookie> getCookies() {
        ArrayList<HttpCookie> arrayList = new ArrayList<HttpCookie>();
        Iterator<URI> iterator = this.d.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(this.a(iterator.next()));
        }
        return arrayList;
    }

    private List<HttpCookie> a(URI uRI) {
        ArrayList<HttpCookie> arrayList;
        HashSet hashSet = new HashSet();
        for (URI object : this.d.keySet()) {
            if (!this.a(object.getHost(), uRI.getHost()) || !this.b(object.getPath(), uRI.getPath())) continue;
            hashSet.addAll(this.d.get(object));
        }
        if (hashSet != null) {
            arrayList = new ArrayList();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                HttpCookie httpCookie = (HttpCookie)iterator.next();
                if (!httpCookie.hasExpired()) continue;
                arrayList.add(httpCookie);
                iterator.remove();
            }
            if (!arrayList.isEmpty()) {
                this.a(uRI, (List<HttpCookie>)arrayList);
            }
        }
        Logger.instance(FlyingConstants.IS_DEBUG)._LOG("Flybits-Cookies", "---------------------------------", LogType.DEBUG);
        Logger.instance(FlyingConstants.IS_DEBUG)._LOG("Flybits-Cookies", "List Of Cookies", LogType.DEBUG);
        arrayList = new ArrayList<HttpCookie>(hashSet);
        for (HttpCookie httpCookie : arrayList) {
            Logger.instance(FlyingConstants.IS_DEBUG)._LOG("Flybits-Cookies", httpCookie.getName() + " : " + httpCookie.getValue(), LogType.DEBUG);
        }
        Logger.instance(FlyingConstants.IS_DEBUG)._LOG("Flybits-Cookies", "---------------------------------", LogType.DEBUG);
        return arrayList;
    }

    private boolean a(String string, String string2) {
        return string2.equals(string) || string2.endsWith("." + string);
    }

    private boolean b(String string, String string2) {
        return string2.equals(string) || string2.startsWith(string) && string.charAt(string.length() - 1) == '/' || string2.startsWith(string) && string2.substring(string.length()).charAt(0) == '/';
    }

    private void a(URI uRI, List<HttpCookie> list) {
        SharedPreferences.Editor editor = this.a.edit();
        for (HttpCookie httpCookie : list) {
            editor.remove(uRI.toString() + "|" + httpCookie.getName());
        }
        editor.apply();
    }

    @Override
    public synchronized List<URI> getURIs() {
        return new ArrayList<URI>(this.d.keySet());
    }

    @Override
    public synchronized boolean remove(URI uri, HttpCookie cookie) {
        boolean bl;
        Logger.instance(FlyingConstants.IS_DEBUG)._LOG("Flybits-Cookies", "Removing Cookie: " + cookie.getName(), LogType.DEBUG);
        Set<HttpCookie> set = this.d.get(uri);
        boolean bl2 = bl = set != null ? set.remove(cookie) : false;
        if (bl) {
            this.c(uri, cookie);
        }
        return bl;
    }

    private void c(URI uRI, HttpCookie httpCookie) {
        SharedPreferences.Editor editor = this.a.edit();
        editor.remove(uRI.toString() + "|" + httpCookie.getName());
        editor.apply();
    }

    @Override
    public synchronized boolean removeAll() {
        this.d.clear();
        this.a();
        return true;
    }

    private void a() {
        SharedPreferences.Editor editor = this.a.edit();
        editor.clear();
        editor.apply();
    }
}

