/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.deserializations;

import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.ServerException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.JWTToken;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.utils.TimeUtilities;
import java.text.ParseException;
import java.util.Calendar;
import org.json.JSONException;
import org.json.JSONObject;

public class DeserializeGetJWT
implements IDeserializer<Result<JWTToken>> {
    @Override
    public String toJson(Result<JWTToken> obj) {
        return null;
    }

    @Override
    public Result<JWTToken> fromJson(String json) {
        Result<JWTToken> result;
        block12: {
            result = new Result<JWTToken>();
            try {
                JSONObject jSONObject = new JSONObject(json);
                if (!jSONObject.isNull("exceptionType")) {
                    result.responseStatus = RequestStatus.FAILED;
                    if (!jSONObject.isNull("exceptionMessage")) {
                        result.exception = new ServerException(jSONObject.getString("exceptionMessage"));
                    }
                    if (result.exception != null && !jSONObject.isNull("exceptionType")) {
                        result.exception.exceptionType = jSONObject.getString("exceptionType");
                    }
                    if (result.exception == null || jSONObject.isNull("dateTime")) break block12;
                    String string = jSONObject.getString("dateTime");
                    try {
                        Calendar calendar = TimeUtilities.toCalendarT(string);
                        if (calendar != null) {
                            result.exception.dateTime = calendar.getTimeInMillis();
                            break block12;
                        }
                        result.exception.dateTime = -1L;
                    }
                    catch (ParseException parseException) {
                        result.exception.dateTime = -1L;
                    }
                    break block12;
                }
                if (!jSONObject.isNull("jwt")) {
                    result.response = new JWTToken();
                    result.responseStatus = RequestStatus.SUCCESS;
                    ((JWTToken)result.response).payload = jSONObject.getString("jwt");
                    if (result.response == null || jSONObject.isNull("expiresAt")) break block12;
                    String string = jSONObject.getString("expiresAt");
                    try {
                        Calendar calendar = TimeUtilities.toCalendarT(string);
                        if (calendar != null) {
                            ((JWTToken)result.response).expiresAt = calendar.getTimeInMillis();
                            break block12;
                        }
                        ((JWTToken)result.response).expiresAt = -1L;
                    }
                    catch (ParseException parseException) {
                        ((JWTToken)result.response).expiresAt = -1L;
                    }
                    break block12;
                }
                result.responseStatus = RequestStatus.FAILED;
                result.exception = new ServerException("There was a server issue detected");
            }
            catch (JSONException jSONException) {
                result.responseStatus = RequestStatus.FAILED;
                result.exception = new ServerException("Error Parsing Response");
            }
        }
        return result;
    }
}

