/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.deserializations;

import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.ServerException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.Device;
import com.flybits.commons.library.models.Pagination;
import com.flybits.commons.library.models.internal.DevicesResponse;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.utils.TimeUtilities;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import org.json.JSONException;
import org.json.JSONObject;

public class DeserializeDevices
implements IDeserializer<Result<DevicesResponse>> {
    @Override
    public String toJson(Result<DevicesResponse> obj) {
        return null;
    }

    @Override
    public Result<DevicesResponse> fromJson(String json) {
        Result<DevicesResponse> result;
        block20: {
            result = new Result<DevicesResponse>();
            try {
                JSONObject jSONObject;
                JSONObject jSONObject2 = new JSONObject(json);
                if (!jSONObject2.isNull("exceptionType")) {
                    result.responseStatus = RequestStatus.FAILED;
                    if (!jSONObject2.isNull("exceptionMessage")) {
                        result.exception = new ServerException(jSONObject2.getString("exceptionMessage"));
                    }
                    if (result.exception != null && !jSONObject2.isNull("exceptionType")) {
                        result.exception.exceptionType = jSONObject2.getString("exceptionType");
                    }
                    if (result.exception == null || jSONObject2.isNull("dateTime")) break block20;
                    String string = jSONObject2.getString("dateTime");
                    try {
                        Calendar calendar = TimeUtilities.toCalendarT(string);
                        if (calendar != null) {
                            result.exception.dateTime = calendar.getTimeInMillis();
                            break block20;
                        }
                        result.exception.dateTime = -1L;
                    }
                    catch (ParseException parseException) {
                        result.exception.dateTime = -1L;
                    }
                    break block20;
                }
                result.response = new DevicesResponse();
                if (!jSONObject2.isNull("pagination")) {
                    jSONObject = jSONObject2.getJSONObject("pagination");
                    ((DevicesResponse)result.response).pagination = new Pagination();
                    if (jSONObject.has("offset")) {
                        ((DevicesResponse)result.response).pagination.offset = jSONObject.getLong("offset");
                    }
                    if (jSONObject.has("limit")) {
                        ((DevicesResponse)result.response).pagination.limit = jSONObject.getLong("limit");
                    }
                    if (jSONObject.has("totalRecords")) {
                        ((DevicesResponse)result.response).pagination.totalRecords = jSONObject.getLong("totalRecords");
                    }
                }
                if (!jSONObject2.isNull("data")) {
                    ((DevicesResponse)result.response).devices = new ArrayList();
                    result.responseStatus = RequestStatus.SUCCESS;
                    jSONObject = jSONObject2.getJSONArray("data");
                    for (int i = 0; i < jSONObject.length(); ++i) {
                        Device device = new Device();
                        JSONObject jSONObject3 = jSONObject.getJSONObject(i);
                        if (!jSONObject3.isNull("id")) {
                            device.id = jSONObject3.getString("id");
                        }
                        if (!jSONObject3.isNull("physicalId")) {
                            device.physicalId = jSONObject3.getString("physicalId");
                        }
                        if (!jSONObject3.isNull("type")) {
                            device.type = Device.Type.fromKey(jSONObject3.getString("type"));
                        }
                        if (!jSONObject3.isNull("createdAt")) {
                            String string = jSONObject3.getString("createdAt");
                            try {
                                Calendar calendar = TimeUtilities.toCalendarT(string);
                                device.createdAt = calendar != null ? calendar.getTimeInMillis() : -1L;
                            }
                            catch (ParseException parseException) {
                                device.createdAt = -1L;
                            }
                        }
                        ((DevicesResponse)result.response).devices.add(device);
                    }
                    break block20;
                }
                result.responseStatus = RequestStatus.FAILED;
                result.exception = new ServerException("There was a server issue detected");
            }
            catch (JSONException jSONException) {
                result.responseStatus = RequestStatus.FAILED;
                result.exception = new ServerException("Error Parsing Response");
            }
        }
        return result;
    }
}

