/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.deserializations;

import com.flybits.commons.library.deserializations.IDeserializer;
import com.flybits.commons.library.exceptions.ServerException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.Device;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.utils.TimeUtilities;
import java.text.ParseException;
import java.util.Calendar;
import org.json.JSONException;
import org.json.JSONObject;

public class DeserializeDevice
implements IDeserializer<Result<Device>> {
    @Override
    public String toJson(Result<Device> obj) {
        return null;
    }

    @Override
    public Result<Device> fromJson(String json) {
        Result<Device> result;
        block14: {
            result = new Result<Device>();
            try {
                JSONObject jSONObject = new JSONObject(json);
                if (!jSONObject.isNull("exceptionType")) {
                    result.responseStatus = RequestStatus.FAILED;
                    if (!jSONObject.isNull("exceptionMessage")) {
                        result.exception = new ServerException(jSONObject.getString("exceptionMessage"));
                    }
                    if (result.exception != null && !jSONObject.isNull("exceptionType")) {
                        result.exception.exceptionType = jSONObject.getString("exceptionType");
                    }
                    if (result.exception == null || jSONObject.isNull("dateTime")) break block14;
                    String string = jSONObject.getString("dateTime");
                    try {
                        Calendar calendar = TimeUtilities.toCalendarT(string);
                        if (calendar != null) {
                            result.exception.dateTime = calendar.getTimeInMillis();
                            break block14;
                        }
                        result.exception.dateTime = -1L;
                    }
                    catch (ParseException parseException) {
                        result.exception.dateTime = -1L;
                    }
                    break block14;
                }
                if (!jSONObject.isNull("id")) {
                    result.response = new Device();
                    result.responseStatus = RequestStatus.SUCCESS;
                    ((Device)result.response).id = jSONObject.getString("id");
                    if (!jSONObject.isNull("physicalId")) {
                        ((Device)result.response).physicalId = jSONObject.getString("physicalId");
                    }
                    if (!jSONObject.isNull("type")) {
                        ((Device)result.response).type = Device.Type.fromKey(jSONObject.getString("type"));
                    }
                    if (jSONObject.isNull("createdAt")) break block14;
                    String string = jSONObject.getString("createdAt");
                    try {
                        Calendar calendar = TimeUtilities.toCalendarT(string);
                        if (calendar != null) {
                            ((Device)result.response).createdAt = calendar.getTimeInMillis();
                            break block14;
                        }
                        ((Device)result.response).createdAt = -1L;
                    }
                    catch (ParseException parseException) {
                        ((Device)result.response).createdAt = -1L;
                    }
                    break block14;
                }
                result.responseStatus = RequestStatus.FAILED;
                result.exception = new ServerException("There was a server issue detected");
            }
            catch (JSONException jSONException) {
                result.responseStatus = RequestStatus.FAILED;
                result.exception = new ServerException("Error Parsing Response");
            }
        }
        return result;
    }
}

