/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api;

import android.content.Context;
import com.flybits.commons.library.FlyingConstants;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.api.FlybitsAPIConstants;
import com.flybits.commons.library.deserializations.DeserializeGetJWT;
import com.flybits.commons.library.exceptions.FlybitsDisabledException;
import com.flybits.commons.library.exceptions.InvalidFlybitsResponseException;
import com.flybits.commons.library.exceptions.ServerException;
import com.flybits.commons.library.http.GetRequest;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.JWTToken;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.models.internal.ServerResult;
import java.io.IOException;

public class FlyJWT {
    public static Result<JWTToken> refreshJWT(Context context) throws InvalidFlybitsResponseException, FlybitsDisabledException {
        String string = FlybitsAPIConstants.constructURL("/Users/jwt");
        try {
            ServerResult serverResult = new GetRequest(context, string).getResponse();
            Object object = new DeserializeGetJWT().fromJson(serverResult.response);
            ((Result)object).responseAsString = serverResult.response;
            if (((Result)object).responseStatus == RequestStatus.SUCCESS) {
                SharedElements.setJWTToken(context, ((JWTToken)((Result)object).response).payload);
            } else if (serverResult.status == 404) {
                ((Result)object).responseStatus = RequestStatus.NOT_FOUND;
                ((Result)object).exception = new ServerException("Error Connecting to Flybits Server: FlyException_JWT1a");
            } else {
                ((Result)object).responseStatus = RequestStatus.FAILED;
                ((Result)object).response = null;
            }
            return object;
        }
        catch (IOException | NullPointerException exception) {
            Logger.instance(FlyingConstants.IS_DEBUG)._LOG_EXCEPTION(exception);
            throw new InvalidFlybitsResponseException("Error Connecting to Flybits Server: FlyException_JWT1b");
        }
    }
}

