/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.api;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import com.flybits.commons.library.FlyingConstants;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.api.FlyDevice;
import com.flybits.commons.library.api.FlybitsAPIConstants;
import com.flybits.commons.library.deserializations.DeserializeLogin;
import com.flybits.commons.library.deserializations.DeserializeServerResult;
import com.flybits.commons.library.exceptions.FlybitsDisabledException;
import com.flybits.commons.library.exceptions.InvalidFlybitsRequestException;
import com.flybits.commons.library.exceptions.InvalidFlybitsResponseException;
import com.flybits.commons.library.http.DeleteRequest;
import com.flybits.commons.library.http.GetRequest;
import com.flybits.commons.library.http.PersistentCookieStore;
import com.flybits.commons.library.http.PostRequest;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.Device;
import com.flybits.commons.library.models.User;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.models.internal.ServerResult;
import com.flybits.commons.library.utils.filters.LoginOptions;
import com.flybits.commons.library.utils.filters.RegisterOptions;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.HashMap;

public class FlyAuthentication {
    public static Result addRememberMe(Context context) throws InvalidFlybitsResponseException, FlybitsDisabledException {
        String string = FlybitsAPIConstants.constructURL("/Users/rememberMe");
        try {
            ServerResult serverResult = new GetRequest(context, string, null).getResponse();
            Result result = new DeserializeServerResult().fromJson(serverResult.response);
            if (result == null) {
                result = new Result();
            }
            result.responseAsString = serverResult.response;
            if (serverResult.status >= 200 && serverResult.status < 300) {
                result.responseStatus = RequestStatus.SUCCESS;
                result.exception = null;
            } else {
                result.responseStatus = serverResult.status == 404 ? RequestStatus.NOT_FOUND : RequestStatus.FAILED;
            }
            return result;
        }
        catch (IOException | NullPointerException exception) {
            Logger.instance(FlyingConstants.IS_DEBUG)._LOG_EXCEPTION(exception);
            FlyAuthentication.a(context);
            throw new InvalidFlybitsResponseException("Error Connecting to Flybits Server: FlyException_Auth1");
        }
    }

    public static Result changePassword(Context context, String oldPassword, String newPassword) throws InvalidFlybitsResponseException, InvalidFlybitsRequestException, FlybitsDisabledException {
        String string = new a(oldPassword, newPassword).a();
        String string2 = FlybitsAPIConstants.constructURL("/Users/ChangePassword");
        try {
            ServerResult serverResult = new PostRequest(context, false, string2, string, null).getResponse();
            Result result = new DeserializeServerResult().fromJson(serverResult.response);
            if (result == null) {
                result = new Result();
            }
            if (serverResult.status >= 200 && serverResult.status < 300) {
                result.responseStatus = RequestStatus.SUCCESS;
                result.exception = null;
            } else {
                result.responseStatus = serverResult.status == 404 ? RequestStatus.NOT_FOUND : RequestStatus.FAILED;
            }
            result.responseAsString = serverResult.response;
            return result;
        }
        catch (IOException | NullPointerException exception) {
            Logger.instance(FlyingConstants.IS_DEBUG)._LOG_EXCEPTION(exception);
            throw new InvalidFlybitsResponseException("Error Connecting to Flybits Server: FlyException_Auth2");
        }
    }

    public static Result disable(Context context) throws InvalidFlybitsResponseException, FlybitsDisabledException {
        String string = "/Users";
        String string2 = FlybitsAPIConstants.constructURL(string);
        try {
            ServerResult serverResult = new DeleteRequest(context, false, string2, null).getResponse();
            Result result = new DeserializeServerResult().fromJson(serverResult.response);
            if (result == null) {
                result = new Result();
            }
            if (serverResult.status >= 200 && serverResult.status < 300) {
                result.responseStatus = RequestStatus.SUCCESS;
                result.exception = null;
                FlyAuthentication.a(context);
            } else {
                result.responseStatus = serverResult.status == 404 ? RequestStatus.NOT_FOUND : RequestStatus.FAILED;
            }
            result.responseAsString = serverResult.response;
            return result;
        }
        catch (IOException | NullPointerException exception) {
            Logger.instance(FlyingConstants.IS_DEBUG)._LOG_EXCEPTION(exception);
            throw new InvalidFlybitsResponseException("Error Connecting to Flybits Server: FlyException_Auth3");
        }
    }

    public static Result forgotPasswordAPI(Context context, String email) throws InvalidFlybitsResponseException, InvalidFlybitsRequestException, FlybitsDisabledException {
        String string = FlybitsAPIConstants.constructURL("/Users/SendResetPasswordEmail");
        String string2 = new b(email).a();
        try {
            ServerResult serverResult = new PostRequest(context, false, string, string2, null).getResponse();
            Result result = new DeserializeServerResult().fromJson(serverResult.response);
            if (result == null) {
                result = new Result();
            }
            result.responseAsString = serverResult.response;
            if (serverResult.status >= 200 && serverResult.status < 300) {
                result.responseStatus = RequestStatus.SUCCESS;
                result.exception = null;
            } else {
                result.responseStatus = serverResult.status == 404 ? RequestStatus.NOT_FOUND : RequestStatus.FAILED;
            }
            return result;
        }
        catch (IOException | NullPointerException exception) {
            Logger.instance(FlyingConstants.IS_DEBUG)._LOG_EXCEPTION(exception);
            throw new InvalidFlybitsResponseException("Error Connecting to Flybits Server: FlyException_Auth4");
        }
    }

    public static Result<User> login(Context context, @NonNull LoginOptions filter) throws InvalidFlybitsResponseException, InvalidFlybitsRequestException, FlybitsDisabledException {
        if (filter == null) {
            throw new InvalidFlybitsRequestException("It appears that your LoginOptions parameter is null. This is not allowed.");
        }
        if (filter.getType() == LoginOptions.FilterBy.LOGIN_ANONYMOUSLY) {
            return FlyAuthentication.b(context, filter);
        }
        return FlyAuthentication.a(context, filter);
    }

    public static Result logoutAPI(Context context) throws InvalidFlybitsResponseException, FlybitsDisabledException, InvalidFlybitsRequestException {
        String string = FlybitsAPIConstants.constructURL("/Users/Logout");
        try {
            ServerResult serverResult = new PostRequest(context, false, string, new HashMap<String, String>(), null).getResponse();
            Result result = new DeserializeServerResult().fromJson(serverResult.response);
            if (result == null) {
                result = new Result();
            }
            result.responseAsString = serverResult.response;
            if (serverResult.status >= 200 && serverResult.status < 300) {
                result.responseStatus = RequestStatus.SUCCESS;
                result.exception = null;
                FlyAuthentication.a(context);
            } else if (serverResult.status == 404) {
                result.responseStatus = RequestStatus.NOT_FOUND;
            } else if (result.exception != null && result.exception.exceptionType != null && result.exception.exceptionType.equalsIgnoreCase("AccessDeniedException")) {
                result.responseStatus = RequestStatus.SUCCESS;
                FlyAuthentication.a(context);
            }
            return result;
        }
        catch (IOException | NullPointerException exception) {
            FlyAuthentication.a(context);
            throw new InvalidFlybitsResponseException("Error Connecting to Flybits Server: FlyException_Auth6");
        }
    }

    public static Result<User> registerUser(Context context, RegisterOptions options) throws InvalidFlybitsResponseException, InvalidFlybitsRequestException, FlybitsDisabledException {
        String string = FlybitsAPIConstants.constructURL("/Users/Register");
        try {
            ServerResult serverResult = new PostRequest(context, false, string, options.getRequest(), null).getResponse();
            Result<User> result = new DeserializeLogin().fromJson(serverResult.response);
            if (result == null) {
                result = new Result<User>();
            }
            result.responseAsString = serverResult.response;
            if (result.responseStatus != null && result.responseStatus == RequestStatus.SUCCESS) {
                if (options.isRetrieveRememberMeToken()) {
                    FlyAuthentication.addRememberMe(context);
                }
                FlyAuthentication.a(context, (User)result.response);
            } else if (serverResult.status == 404) {
                result.responseStatus = RequestStatus.NOT_FOUND;
            }
            return result;
        }
        catch (IOException | NullPointerException exception) {
            Logger.instance(FlyingConstants.IS_DEBUG)._LOG_EXCEPTION(exception);
            throw new InvalidFlybitsResponseException("Error Connecting to Flybits Server: FlyException_Auth7");
        }
    }

    static boolean a(Context context, @NonNull User user) {
        if (user != null && user.id != null) {
            SharedElements.setUserID(context, user.id);
            if (user.jwtToken != null) {
                SharedElements.setJWTToken(context, user.jwtToken);
            }
            try {
                Result<Device> result = FlyDevice.addToDevices(context);
                if (result.responseStatus != RequestStatus.SUCCESS || result.response == null || ((Device)result.response).id == null) {
                    return false;
                }
                SharedElements.setDeviceID(context, ((Device)result.response).id);
            }
            catch (FlybitsDisabledException | InvalidFlybitsRequestException | InvalidFlybitsResponseException exception) {
                Logger.instance(FlyingConstants.IS_DEBUG)._LOG_EXCEPTION(exception);
                return false;
            }
            return true;
        }
        return false;
    }

    static void a(Context context) {
        SharedPreferences sharedPreferences = SharedElements.getPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        editor.apply();
        PersistentCookieStore persistentCookieStore = new PersistentCookieStore(context);
        persistentCookieStore.removeAll();
    }

    private static Result<User> a(Context context, @NonNull LoginOptions loginOptions) throws InvalidFlybitsResponseException, InvalidFlybitsRequestException, FlybitsDisabledException {
        try {
            String string = loginOptions.getFilter();
            String string2 = FlybitsAPIConstants.constructURL(loginOptions.getEndpoint());
            ServerResult serverResult = new PostRequest(context, false, string2, string, null).getResponse();
            Object object = new DeserializeLogin().fromJson(serverResult.response);
            ((Result)object).responseAsString = serverResult.response;
            if (serverResult.status >= 200 && serverResult.status < 300 && ((Result)object).responseStatus == RequestStatus.SUCCESS) {
                FlyAuthentication.a(context, (User)((Result)object).response);
            } else if (serverResult.status >= 200 && serverResult.status < 300) {
                Result result = FlyAuthentication.logoutAPI(context);
                if (result.responseStatus != RequestStatus.SUCCESS) {
                    FlyAuthentication.a(context);
                }
                ((Result)object).responseStatus = RequestStatus.FAILED;
            } else if (serverResult.status == 404) {
                ((Result)object).responseStatus = RequestStatus.NOT_FOUND;
            }
            return object;
        }
        catch (IOException | NullPointerException exception) {
            Logger.instance(FlyingConstants.IS_DEBUG)._LOG_EXCEPTION(exception);
            throw new InvalidFlybitsResponseException("Error Connecting to Flybits Server: FlyException_Auth5");
        }
    }

    private static Result<User> b(Context context, @NonNull LoginOptions loginOptions) throws InvalidFlybitsResponseException, InvalidFlybitsRequestException, FlybitsDisabledException {
        SecureRandom secureRandom = new SecureRandom();
        String string = new BigInteger(130, secureRandom).toString(32) + "@flybits.com";
        String string2 = new BigInteger(130, secureRandom).toString(32);
        RegisterOptions.Builder.Options options = new RegisterOptions.Builder().setUserCredentials(string, string2);
        if (!loginOptions.isJWTSet()) {
            options.disableJWT();
        }
        if (!loginOptions.isRememberMeSet()) {
            options.disableRememberMe();
        }
        return FlyAuthentication.registerUser(context, options.build());
    }

    private static class a {
        String a;
        String b;

        a(String string, String string2) {
            this.a = string;
            this.b = string2;
        }

        String a() {
            return "{\"currentPassword\" : \"" + this.a + "\", \"newPassword\" : \"" + this.b + "\"}";
        }
    }

    private static class b {
        private String a;

        b(String string) {
            this.a = string;
        }

        String a() {
            return "{\"email\" : \"" + this.a + "\"}";
        }
    }
}

