/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import com.flybits.commons.library.utils.Utilities;
import java.util.ArrayList;

public class SharedElements {
    public static ArrayList<String> getEnabledLanguagesAsArray(Context context) {
        SharedPreferences sharedPreferences = SharedElements.getPreferences(context);
        String string = sharedPreferences.getString("LANGUAGE_CODES", "");
        return Utilities.convertLocalizationStringToList(string);
    }

    public static String getEnabledLanguagesAsString(Context context) {
        SharedPreferences sharedPreferences = SharedElements.getPreferences(context);
        return sharedPreferences.getString("LANGUAGE_CODES", "");
    }

    public static String getDeviceID(Context context) {
        SharedPreferences sharedPreferences = SharedElements.getPreferences(context);
        return sharedPreferences.getString("DEVICE_ID", "");
    }

    public static String getSavedJWTToken(Context context) {
        SharedPreferences sharedPreferences = SharedElements.getPreferences(context);
        return sharedPreferences.getString("JWT_TOKEN", "");
    }

    public static String getUserID(Context context) {
        SharedPreferences sharedPreferences = SharedElements.getPreferences(context);
        return sharedPreferences.getString("USER_ID", "");
    }

    public static boolean isFlybitsAuthenticated(Context context) {
        SharedPreferences sharedPreferences = SharedElements.getPreferences(context);
        return sharedPreferences.getBoolean("LOGIN_AUTHENTICATED", false);
    }

    public static void setDeviceID(@NonNull Context context, @NonNull String deviceID) {
        SharedElements.a(context, "DEVICE_ID", deviceID);
    }

    public static void setFlybitsXAuthentication(Context context, boolean isAuthenticated) {
        SharedElements.a(context, "LOGIN_AUTHENTICATED", isAuthenticated);
    }

    public static void setJWTToken(Context context, @NonNull String jwtToken) {
        SharedElements.a(context, "JWT_TOKEN", jwtToken);
    }

    public static void setLocalization(Context context, ArrayList<String> listOfLanguages) {
        SharedPreferences.Editor editor = SharedElements.getPreferences(context).edit();
        editor.putString("LANGUAGE_CODES", Utilities.convertLocalizationCodeToString(listOfLanguages));
        editor.apply();
    }

    public static void setUserID(Context context, @NonNull String userID) {
        SharedElements.a(context, "USER_ID", userID);
    }

    public static SharedPreferences getPreferences(Context context) {
        return context.getSharedPreferences("FLYBITS_PREF", 0);
    }

    private static void a(Context context, @NonNull String string, @NonNull String string2) {
        SharedPreferences.Editor editor = SharedElements.getPreferences(context).edit();
        editor.putString(string, string2);
        editor.apply();
    }

    private static void a(Context context, @NonNull String string, boolean bl) {
        SharedPreferences.Editor editor = SharedElements.getPreferences(context).edit();
        editor.putBoolean(string, bl);
        editor.apply();
    }
}

