package com.flybits.commons.library.models;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * This class that represents a device's JWT information. This {@code JWTToken} is used to define
 * a specific user/device combination.
 *
 * @since 1.0.0
 */
public class JWTToken implements Parcelable{

    /**
     * The payload indicates the JWT token.
     */
    public String payload;

    /**
    * The time in milliseconds which indicates when the payload expires. This is useful
     * information for determining when the SDK should refresh its JWT token.
    */
    public long expiresAt;

    /**
     * Initial Empty Constructor.
     */
    public JWTToken(){}

    /**
     * Constructor used for un-flattening a {@code JWTToken} parcel.
     *
     * @param in the parcel that contains the un-flattened {@code JWTToken} parcel.
     */
    public JWTToken(Parcel in){
        expiresAt   = in.readLong();
        payload     = in.readString();
    }

    /**
     * Describe the kinds of special objects contained in this Parcelable's marshalled representation.
     *
     * @return a bitmask indicating the set of special object types marshalled by the Parcelable.
     */
    public int describeContents() {
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        JWTToken jwtToken = (JWTToken) o;

        return payload != null ? payload.equals(jwtToken.payload) : jwtToken.payload == null;

    }

    /**
     * Flatten this {@code Device} into a Parcel.
     *
     * @param out The Parcel in which the {@code Device} object should be written.
     * @param flags Additional flags about how the DateOfBirth object should be written.
     * May be 0 or {@link #PARCELABLE_WRITE_RETURN_VALUE}.
     */
    public void writeToParcel(Parcel out, int flags) {

        out.writeLong(expiresAt);
        out.writeString(payload);
    }

    /**
     * Parcelable.Creator that instantiates {@code JWTToken} objects
     */
    public static final Creator<JWTToken> CREATOR = new Creator<JWTToken>() {
        public JWTToken createFromParcel(Parcel in) {
            return new JWTToken(in);
        }

        public JWTToken[] newArray(int size) {
            return new JWTToken[size];
        }
    };
}
