package com.flybits.commons.library.logging;

import android.support.annotation.NonNull;
import android.util.Log;

public class Logger {

    private static Logger mInstance = null;
    private boolean IS_DEBUG = false;

    public static Logger instance(@NonNull boolean isDebug) {
        if (mInstance == null) {
            synchronized (Logger.class){
                if (mInstance == null){
                    mInstance = new Logger(isDebug);
                }
            }
        }
        return mInstance;
    }

    Logger(boolean isDebug){
        this.IS_DEBUG   = isDebug;
    }

    /**
     * Creates a log statement in the logcat that displays information that may be useful for
     * developers.
     *
     * @param tag - The tag under which the log should be displayed under.
     * @param msg - The message to be displayed in the logcat.
     * @param type - The type of message it is.
     */
    public void _LOG(@NonNull String tag, @NonNull String msg, @NonNull LogType type){
        if (IS_DEBUG) {
            switch (type) {
                case DEBUG:
                    Log.d(tag, msg);
                    break;
                case ERROR:
                    Log.e(tag, msg);
                    break;
                case WARN:
                    Log.w(tag, msg);
                    break;
                case INFO:
                    Log.i(tag, msg);
                    break;
            }
        }
    }

    /**
     * Creates a log statement in the logcat that will display an exception's information and print
     * the stack trace. This is only available is the user has set activated logging when they
     * initiate Flybits for the first time.
     *
     * @param e - The exception to display information about.
     */
    //USED
    public void _LOG_EXCEPTION(@NonNull Exception e){
        if (IS_DEBUG) {
            e.printStackTrace();
        }
    }

}
