package com.flybits.commons.library.logging;

/**
 * The LogType class is used to define the various types of Log statements that are displayed in
 * the logcat through the SDK.
 *
 * @since 2.0.0
 */
public enum LogType {

    /**
     * Indicates that the Log statement should be marked as debug in the logcat.
     */
    DEBUG,

    /**
     * Indicates that the Log statement should be marked as error in the logcat.
     */
    ERROR,

    /**
     * Indicates that the Log statement should be marked as information in the logcat.
     */
    INFO,

    /**
     * Indicates that the Log statement should be marked as warning in the logcat.
     */
    WARN
}
