package com.flybits.commons.library.interfaces;

import com.flybits.commons.library.models.Pagination;

/**
 * This callback is initiated by the SDK when a web request response with a list of objects. In
 * addition with the list of object every request contains a {@link Pagination} object which
 * indicates {@link Pagination#totalRecords}, {@link Pagination#limit}, and {@link Pagination#offset}
 * For example, whenever gets to get a list of zones based on a specific location then a list of
 * objects will be returned with the {@link Pagination} object as well associated to the callback.
 *
 * @since 1.0.0
 */
public abstract class IRequestPaginationCallback<T> extends IGenericAbstractCallback{

    /**
     * Indicates that the SDK request to the Flybits Core was successfully performed.
     *
     * @param data Object that represents the expected response from the Flybits Core.
     * @param pagination The {@link Pagination} object that indicates the total number of records
     *                   for this request, the number of records returned, along with the offset of
     *                   the first record in the returned list.
     */
    public abstract void onSuccess(final T data, Pagination pagination);
}
