package com.flybits.commons.library.interfaces;

import com.flybits.commons.library.models.User;

/**
 * This callback is initiated by the SDK when a web request returns a single object from the Flybits
 * core. For example, if the application is attempting to login to the Flybits Core through
 * {@code Login} the expected result is the {@link User} profile when the request is successful.
 *
 * @param <T> The model expected to be returned when the request is successful.
 * @since 1.0.0
 */
public abstract class IRequestCallback<T>  extends IGenericAbstractCallback{

    /**
     * Indicates that the SDK request to the Flybits Core was successfully performed.
     *
     * @param data Object that represents the expected response from the Flybits Core.
     */
    public abstract void onSuccess(final T data);
}
