package com.flybits.commons.library.interfaces;

import com.flybits.commons.library.exceptions.ServerException;

/**
 * This abstract callback is initiated by the SDK when a web request returns an object to the SDK.
 * The options available in through this abstract class include generic options that should be
 * available in all SDK Flybits Core requests.
 *
 *  @since 1.0.0
 */
public abstract class IGenericAbstractCallback {

    /**
     * Indicates that the SDK request was unsuccessful due to an exception which either occurred on
     * the Flybits Core or within the SDK. All exceptions throw by the Flybits core should be
     * initiated as {@link ServerException}, if an none Flybits Server exception is thrown it means
     * that something unexpected occurred within the SDK. In most cases this would be due to the
     * fact that unexpected server response was delivered.
     *
     * @param exception The exception that cause the SDK to not be able to process the request.
     */
    public abstract void onException(Exception exception);

    @Deprecated
    public abstract void onFailed(String reason);

    /**
     * Indicates that request has been completed and that the application can cleanup any functions
     * related to this SDK request. A good use of this method is to cancel any progress dialogs that
     * may pertain to the SDK method.
     */
    public abstract void onCompleted();
}
