package com.flybits.commons.library.exceptions;

/**
 *  The {@code ServiceNotSetException} is thrown whenever the application has not added a service
 *  to the {@code AndroidManifest.xml} file that is needed to continue.
 *
 *  @since 1.0.0
 */
public class ServiceNotSetException extends RuntimeException {

    /**
     * Constructs a new {@code ServiceNotSetException} that includes the current stack trace.
     */
    public ServiceNotSetException() {}

    /**
     * Constructs a new {@code ServiceNotSetException} with the current stack trace and the specified
     * detail message.
     *
     * @param message the detail message for this exception.
     */
    public ServiceNotSetException(String message) {
        super(message);
    }

    /**
     * Constructs a new {@code ServiceNotSetException} with the current stack trace and the specified
     * cause.
     *
     * @param throwable the cause of this exception.
     */
    public ServiceNotSetException(Throwable throwable) {
        super(throwable);
    }

    /**
     * Constructs a new {@code ServiceNotSetException} with the current stack trace,
     * the specified detail message and the specified cause.
     *
     * @param detailMessage the detail message for this exception.
     * @param throwable the cause of this exception.
     */
    public ServiceNotSetException(String detailMessage, Throwable throwable) {
        super(detailMessage, throwable);
    }
}