package com.flybits.commons.library.exceptions;

/**
 * A class that represents an exception that was thrown by a the Flybits Core during a request to
 * the server in order to obtain specific information.
 *
 * @since 1.0.0
 */
public class ServerException extends Exception {

    /**
     * The time that the exception occurred. The time is represented in milliseconds since
     * January 1, 1970. This value is provided by the Flybits Core representing when the error on
     * the server occurred.
     */
    public long dateTime;

    /**
     * The generic exception type/code that can be used to express why an error was committed.
     * For example some common cases include;
     * <ul>
     *     <li>UserNotFoundException: Indicates that the user you were looking for does not exist</li>
     *     <li>InvalidCredentialException: Indicates that the login credentials for a user attempting
     *     to login were incorrect</li>
     *     <li>AccessDeniedException: Indicates that you are attempting to access something that you
     *     do not have permission to.</li>
     * </ul>
     */
    public String exceptionType;

    /**
     * Constructs a new {@code ContextBrokerNotActiveException} that includes the current stack trace.
     */
    public ServerException(){}

    /**
     * Constructs a new {@code ContextBrokerNotActiveException} with the current stack trace and the specified
     * detail message.
     *
     * @param message the detail message for this exception.
     */
    public ServerException(String message) {
        super(message);
    }

    /**
     * Constructs a new {@code ContextBrokerNotActiveException} with the current stack trace and the specified
     * cause.
     *
     * @param throwable the cause of this exception.
     */
    public ServerException(Throwable throwable){
        super(throwable);
    }

    /**
     * Constructs a new {@code ContextBrokerNotActiveException} with the current stack trace,
     * the specified detail message and the specified cause.
     *
     * @param detailMessage the detail message for this exception.
     * @param throwable the cause of this exception.
     */
    public ServerException(String detailMessage, Throwable throwable){
        super(detailMessage, throwable);
    }
}
