package com.flybits.commons.library.exceptions;

/**
 *  The {@code InvalidFlybitsRequestException} is thrown when the application requests for
 *  information through the SDK that requires a network call to the Flybits Core. If the SDK
 *  receives data from the Flybits Core that it cannot understand it will then throw this exception.
 *  In all cases this will result in the onException(Exception e) method of a SDK callback to be
 *  thrown.
 *
 *  @since 1.0.0
 */
public class InvalidFlybitsRequestException extends Exception {

    /**
     * Constructs a new {@code InvalidFlybitsRequestException} that includes the current stack
     * trace.
     */
    public InvalidFlybitsRequestException(){}

    /**
     * Constructs a new {@code InvalidFlybitsRequestException} with the current stack trace and the
     * specified detail message.
     *
     * @param message the detail message for this exception.
     */
    public InvalidFlybitsRequestException(String message) {
        super(message);
    }

    /**
     * Constructs a new {@code InvalidFlybitsRequestException} with the current stack trace and the
     * specified cause.
     *
     * @param throwable the cause of this exception.
     */
    public InvalidFlybitsRequestException(Throwable throwable){
        super(throwable);
    }

    /**
     * Constructs a new {@code InvalidFlybitsRequestException} with the current stack trace,
     * the specified detail message and the specified cause.
     *
     * @param detailMessage the detail message for this exception.
     * @param throwable the cause of this exception.
     */
    public InvalidFlybitsRequestException(String detailMessage, Throwable throwable){
        super(detailMessage, throwable);
    }
}