package com.flybits.commons.library.deserializations;

import com.flybits.commons.library.exceptions.ServerException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.models.JWTToken;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.commons.library.utils.TimeUtilities;

import org.json.JSONException;
import org.json.JSONObject;

import java.text.ParseException;
import java.util.Calendar;

public class DeserializeGetJWT implements IDeserializer<Result<JWTToken>>{

    @Override
    public String toJson(Result<JWTToken> obj) {
        return null;
    }

    @Override
    public Result<JWTToken> fromJson(String json) {

        Result<JWTToken> jwtToken = new Result<>();

        try {
            JSONObject jObj = new JSONObject(json);

            if (!jObj.isNull("exceptionType")){
                jwtToken.responseStatus    = RequestStatus.FAILED;

                if (!jObj.isNull("exceptionMessage")){
                    jwtToken.exception         = new ServerException(jObj.getString("exceptionMessage"));
                }

                if (jwtToken.exception != null && !jObj.isNull("exceptionType")){
                    jwtToken.exception.exceptionType = jObj.getString("exceptionType");
                }

                if (jwtToken.exception != null && !jObj.isNull("dateTime")) {
                    String date = jObj.getString("dateTime");
                    try {
                        Calendar calendar       = TimeUtilities.toCalendarT(date);
                        if (calendar != null) {
                            jwtToken.exception.dateTime = calendar.getTimeInMillis();
                        }else{
                            jwtToken.exception.dateTime = -1;
                        }
                    }catch(ParseException exceptionArgs){
                        jwtToken.exception.dateTime = -1;
                    }
                }
            }else{
                if (!jObj.isNull("jwt")){

                    jwtToken.response               = new JWTToken();
                    jwtToken.responseStatus = RequestStatus.SUCCESS;
                    jwtToken.response.payload   = jObj.getString("jwt");

                    if (jwtToken.response != null && !jObj.isNull("expiresAt")) {
                        String date = jObj.getString("expiresAt");
                        try {
                            Calendar calendar       = TimeUtilities.toCalendarT(date);
                            if (calendar != null) {
                                jwtToken.response.expiresAt = calendar.getTimeInMillis();
                            }else{
                                jwtToken.response.expiresAt = -1;
                            }
                        }catch(ParseException exceptionArgs){
                            jwtToken.response.expiresAt = -1;
                        }
                    }
                }else {
                    jwtToken.responseStatus = RequestStatus.FAILED;
                    jwtToken.exception         = new ServerException("There was a server issue detected");
                }
            }

        }catch (JSONException e){
            jwtToken.responseStatus    = RequestStatus.FAILED;
            jwtToken.exception         = new ServerException("Error Parsing Response");
        }
        return jwtToken;
    }
}
