package com.flybits.commons.library.api;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Bundle;

import com.flybits.commons.library.BuildConfig;
import com.flybits.commons.library.FlyingConstants;
import com.flybits.commons.library.exceptions.APIKeyNotSetException;
import com.flybits.commons.library.logging.Logger;

/**
 * This {@code FlybitsAPIConstants} class contains all Flybits Related
 */
public class FlybitsAPIConstants {

    protected static final String API_V2                                = "/v2";
    protected static final String API_USER                              = "/Users";
    protected static final String API_JWT                               = "/jwt";
    protected static final String API_IMAGE                             = "/Images";
    protected static final String API_DEVICES                           = "/Devices";

    public static final String API_LOGIN                                = API_USER + "/Login";
    public static final String API_LOGIN_SIGNED                         = API_USER + "/SignedLogin";
    protected static final String API_LOGOUT                            = API_USER + "/Logout";
    protected static final String API_REGISTER                          = API_USER + "/Register";
    protected static final String API_REMEMBERME                        = API_USER + "/rememberMe";
    protected static final String API_FORGOT_PASSWORD                   = API_USER + "/SendResetPasswordEmail";
    protected static final String API_CHANGE_PASSWORD                   = API_USER + "/ChangePassword";
    protected static final String API_CHANGE_EMAIL                      = API_USER + "/ChangeEmail";
    protected static final String API_IMAGE_UPLOAD                      = API_IMAGE + "/Upload";
    protected static final String API_IMAGE_CROP                        = API_IMAGE + "/Crop";
    protected static final String API_ME                                = "/me";

    public static final String USER_ACCESS_DENIED                       = "AccessDenied";

    public static String getURL() {
        return BuildConfig.CORE + API_V2;
    }

    public static String getURI(){
        return BuildConfig.CORE;
    }

    public static String getGatewayURL() throws APIKeyNotSetException {
        return BuildConfig.GATEWAY;
    }

    public static String getMQTTURL() throws APIKeyNotSetException {
        return BuildConfig.MQTT;
    }

    public static String constructURL(String endpoint){
        return getURL() + endpoint;
    }

    public static String getAPIKey(Context context) throws APIKeyNotSetException{
        return getMyAPIKey(context);
    }

    public static String constructGatewayURL(String endpoint){
        return getGatewayURL() + endpoint;
    }

    public static String getMyAPIKey(Context mContext) throws APIKeyNotSetException{
        try {
            android.content.pm.ApplicationInfo ai = mContext.getPackageManager().getApplicationInfo(mContext.getPackageName(), PackageManager.GET_META_DATA);
            Bundle bundle = ai.metaData;

            if (bundle.containsKey("com.flybits.apikey")){
                return bundle.getString("com.flybits.apikey");
            }
        } catch (PackageManager.NameNotFoundException | NullPointerException e) {
            Logger.instance(FlyingConstants.IS_DEBUG)._LOG_EXCEPTION(e);
        }

        throw new APIKeyNotSetException("Your Api Key is not set. Please set it through the FlybitsOptions object and make sure you initialize the Flybits singleton with the FlybitsOptions object.");
    }
}