/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.internal.models.preferences;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.api.results.BasicResult;
import com.flybits.commons.library.api.results.ObjectResult;
import com.flybits.commons.library.api.results.callbacks.BasicResultCallback;
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.exceptions.InvalidJsonFormatException;
import com.flybits.commons.library.exceptions.NotFoundException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.JsonParser;
import com.flybits.commons.library.models.internal.Result;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FlybitsPreferences {
    static final String API_USER_PREF = "/kernel/userpref";
    private static final String TAG = "FlyPrefs";
    static MediaType MEDIA_TYPE_PLAIN = MediaType.parse((String)"text/plain; charset=utf-8");
    private Context context;
    private Handler handler;

    public FlybitsPreferences(Context context) {
        this.context = context;
        this.handler = new Handler(Looper.getMainLooper());
    }

    public FlybitsPreferences(Context context, Handler handler) {
        this.context = context;
        this.handler = handler;
    }

    public BasicResult clear(BasicResultCallback callback) {
        return this.delete(this.context, null, callback);
    }

    public ObjectResult<Boolean> getBoolean(String key, boolean defaultValue, ObjectResultCallback<Boolean> callback) {
        return this.get(this.context, key, defaultValue, Boolean.class, callback);
    }

    public ObjectResult<ArrayList<Boolean>> getBooleanList(String key, ObjectResultCallback<ArrayList<Boolean>> callback) {
        return this.getList(this.context, key, callback);
    }

    public Context getContext() {
        return this.context;
    }

    public ObjectResult<Double> getDouble(String key, double defaultValue, ObjectResultCallback<Double> callback) {
        return this.get(this.context, key, defaultValue, Double.class, callback);
    }

    public ObjectResult<ArrayList<Double>> getDoubleList(String key, ObjectResultCallback<ArrayList<Double>> callback) {
        return this.getList(this.context, key, callback);
    }

    protected Handler getHandler() {
        return this.handler;
    }

    public ObjectResult<Integer> getInt(String key, int defaultValue, ObjectResultCallback<Integer> callback) {
        return this.get(this.context, key, defaultValue, Integer.class, callback);
    }

    public ObjectResult<ArrayList<Integer>> getIntList(String key, ObjectResultCallback<ArrayList<Integer>> callback) {
        return this.getList(this.context, key, callback);
    }

    public ObjectResult<Long> getLong(String key, long defaultValue, ObjectResultCallback<Long> callback) {
        return this.get(this.context, key, defaultValue, Long.class, callback);
    }

    public ObjectResult<ArrayList<Long>> getLongList(String key, ObjectResultCallback<ArrayList<Long>> callback) {
        return this.getList(this.context, key, callback);
    }

    public <T extends JsonParser> ObjectResult<T> getObject(String key, Class<T> clazz, ObjectResultCallback<T> callback) {
        return this.getJson(this.context, key, clazz, callback);
    }

    public <T extends JsonParser> ObjectResult<ArrayList<T>> getObjectList(String key, Class<T> clazz, ObjectResultCallback<ArrayList<T>> callback) {
        return this.getJsonList(this.context, key, clazz, callback);
    }

    public ObjectResult<String> getString(String key, String defaultValue, ObjectResultCallback<String> callback) {
        return this.get(this.context, key, defaultValue, String.class, callback);
    }

    public ObjectResult<ArrayList<String>> getStringList(String key, ObjectResultCallback<ArrayList<String>> callback) {
        return this.getList(this.context, key, callback);
    }

    public BasicResult putBoolean(String key, boolean value, BasicResultCallback callback) {
        return this.update(this.context, key, RequestBody.create((MediaType)MEDIA_TYPE_PLAIN, (String)Boolean.toString(value)), callback, PreferencesType.IS_BOOLEAN);
    }

    public BasicResult putBooleanList(String key, ArrayList<Boolean> values, BasicResultCallback callback) {
        return this.putInternalArrayList(key, values, callback);
    }

    public BasicResult putDouble(String key, double value, BasicResultCallback callback) {
        return this.update(this.context, key, RequestBody.create((MediaType)MEDIA_TYPE_PLAIN, (String)Double.toString(value)), callback, PreferencesType.IS_DOUBLE);
    }

    public BasicResult putDoubleList(String key, ArrayList<Double> values, BasicResultCallback callback) {
        return this.putInternalArrayList(key, values, callback);
    }

    public BasicResult putInt(String key, int value, BasicResultCallback callback) {
        return this.update(this.context, key, RequestBody.create((MediaType)MEDIA_TYPE_PLAIN, (String)Integer.toString(value)), callback, PreferencesType.IS_INTEGER);
    }

    public BasicResult putIntList(String key, ArrayList<Integer> values, BasicResultCallback callback) {
        return this.putInternalArrayList(key, values, callback);
    }

    public BasicResult putLong(String key, long value, BasicResultCallback callback) {
        return this.update(this.context, key, RequestBody.create((MediaType)MEDIA_TYPE_PLAIN, (String)Long.toString(value)), callback, PreferencesType.IS_LONG);
    }

    public BasicResult putLongList(String key, ArrayList<Long> values, BasicResultCallback callback) {
        return this.putInternalArrayList(key, values, callback);
    }

    public BasicResult putObject(String key, JsonParser value, BasicResultCallback callback) {
        RequestBody json = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)value.toJson().toString());
        return this.update(this.context, key, json, callback, PreferencesType.IS_OBJECT);
    }

    public BasicResult putObjectList(String key, ArrayList<? extends JsonParser> values, BasicResultCallback callback) {
        JSONArray array = new JSONArray();
        for (JsonParser jsonParser : values) {
            array.put((Object)jsonParser.toJson());
        }
        RequestBody json = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)array.toString());
        return this.update(this.context, key, json, callback, PreferencesType.IS_OBJECT_LIST);
    }

    public BasicResult putString(String key, String value, BasicResultCallback callback) {
        String valueFilter = value;
        try {
            new JSONObject(value);
        }
        catch (JSONException e) {
            try {
                new JSONArray(value);
            }
            catch (JSONException ignored) {
                valueFilter = value.replace("\n", "").replace("\t", "").trim();
            }
        }
        return this.update(this.context, key, RequestBody.create((MediaType)MEDIA_TYPE_PLAIN, (String)valueFilter), callback, PreferencesType.IS_STRING);
    }

    public BasicResult putStringList(String key, ArrayList<String> values, BasicResultCallback callback) {
        return this.putInternalArrayList(key, values, callback);
    }

    public BasicResult remove(String key, BasicResultCallback callback) {
        return this.delete(this.context, key, callback);
    }

    protected BasicResult delete(@NonNull Context context, String key, BasicResultCallback callback) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        BasicResult request = new BasicResult(callback, this.handler, executorService);
        executorService.execute(() -> {
            Result<?> deleteUserPref;
            String methodIdentifier = "UserPreference.clear";
            String url = API_USER_PREF;
            if (key != null) {
                url = url + "/" + key;
            }
            if ((deleteUserPref = FlyAway.delete(context, url, methodIdentifier, null)).getStatus() == RequestStatus.COMPLETED || deleteUserPref.getStatus() == RequestStatus.NOT_FOUND) {
                request.setSuccess();
            } else {
                request.setFailed(deleteUserPref.getException());
            }
        });
        return request;
    }

    protected <T> ObjectResult<T> get(final @NonNull Context context, final String key, final T defaultValue, final Class<T> clazz, ObjectResultCallback<T> callback) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final ObjectResult<T> request = new ObjectResult<T>(callback, this.handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    String url = "/kernel/userpref/" + key;
                    String methodIdentifier = "UserPreference.get";
                    Result getUserPrefs = FlyAway.get(context, url, null, methodIdentifier, null);
                    if (getUserPrefs.getStatus() == RequestStatus.COMPLETED) {
                        String response = getUserPrefs.getResponseAsString();
                        if (clazz.isAssignableFrom(String.class)) {
                            request.setSuccess(response);
                        } else if (clazz.isAssignableFrom(Integer.class)) {
                            request.setSuccess(Integer.valueOf(response));
                        } else if (clazz.isAssignableFrom(Boolean.class)) {
                            request.setSuccess(Boolean.valueOf(response));
                        } else if (clazz.isAssignableFrom(Double.class)) {
                            request.setSuccess(Double.valueOf(response));
                        } else if (clazz.isAssignableFrom(Long.class)) {
                            request.setSuccess(Long.valueOf(response));
                        } else {
                            Logger.e("FlybitsPreferences : InvalidJsonFormatException :" + key);
                            request.setFailed(new InvalidJsonFormatException());
                        }
                    } else if (getUserPrefs.getStatus() == RequestStatus.NOT_FOUND) {
                        request.setSuccess(defaultValue);
                    } else {
                        request.setResult(getUserPrefs);
                    }
                }
                catch (Exception exception) {
                    request.setFailed(new FlybitsException(exception.getMessage()));
                }
            }
        });
        return request;
    }

    protected <T extends JsonParser> ObjectResult<T> getJson(@NonNull Context context, String key, Class<T> clazz, ObjectResultCallback<T> callback) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ObjectResult request = new ObjectResult(callback, this.handler, executorService);
        executorService.execute(() -> {
            String methodIdentifier;
            String url = "/kernel/userpref/" + key;
            Result getUserPrefs = FlyAway.get(context, url, null, methodIdentifier = "UserPreference.get", null);
            if (getUserPrefs.getStatus() == RequestStatus.COMPLETED) {
                String response = getUserPrefs.getResponseAsString();
                try {
                    JsonParser newInstance = (JsonParser)clazz.newInstance();
                    newInstance.fromJson(response);
                    request.setSuccess(newInstance);
                }
                catch (ClassCastException | IllegalAccessException | InstantiationException ex) {
                    request.setFailed(new InvalidJsonFormatException());
                }
            } else if (getUserPrefs.getStatus() == RequestStatus.NOT_FOUND) {
                request.setFailed(new NotFoundException());
            } else {
                request.setFailed(getUserPrefs.getException());
            }
        });
        return request;
    }

    protected <T extends JsonParser> ObjectResult<ArrayList<T>> getJsonList(@NonNull Context context, String key, Class<T> clazz, ObjectResultCallback<ArrayList<T>> callback) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ObjectResult request = new ObjectResult(callback, this.handler, executorService);
        executorService.execute(() -> {
            String methodIdentifier;
            String url = "/kernel/userpref/" + key;
            Result getUserPrefs = FlyAway.get(context, url, null, methodIdentifier = "UserPreference.get", null);
            if (getUserPrefs.getStatus() == RequestStatus.COMPLETED) {
                String response = getUserPrefs.getResponseAsString();
                try {
                    ArrayList<JsonParser> listOfObjects = new ArrayList<JsonParser>();
                    JSONArray array = new JSONArray(response);
                    for (int i = 0; i < array.length(); ++i) {
                        JsonParser newInstance = (JsonParser)clazz.newInstance();
                        newInstance.fromJson(array.getJSONObject(i).toString());
                        listOfObjects.add(newInstance);
                    }
                    request.setSuccess(listOfObjects);
                }
                catch (ClassCastException | IllegalAccessException | InstantiationException | JSONException ex) {
                    request.setFailed(new InvalidJsonFormatException());
                }
            } else if (getUserPrefs.getStatus() == RequestStatus.NOT_FOUND) {
                request.setSuccess(new ArrayList());
            } else {
                request.setFailed(getUserPrefs.getException());
            }
        });
        return request;
    }

    protected <T> ObjectResult<ArrayList<T>> getList(@NonNull Context context, String key, ObjectResultCallback<ArrayList<T>> callback) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        ObjectResult request = new ObjectResult(callback, this.handler, executorService);
        executorService.execute(() -> {
            String methodIdentifier;
            String url = "/kernel/userpref/" + key;
            Result getUserPrefs = FlyAway.get(context, url, null, methodIdentifier = "UserPreference.get", null);
            if (getUserPrefs.getStatus() == RequestStatus.COMPLETED) {
                String response = getUserPrefs.getResponseAsString();
                try {
                    JSONArray jsonArray = new JSONArray(response);
                    ArrayList<Object> listOfItems = new ArrayList<Object>();
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        listOfItems.add(jsonArray.get(i));
                    }
                    request.setSuccess(listOfItems);
                }
                catch (ClassCastException | JSONException ex) {
                    request.setFailed(new InvalidJsonFormatException());
                }
            } else if (getUserPrefs.getStatus() == RequestStatus.NOT_FOUND) {
                request.setSuccess(new ArrayList());
            } else {
                request.setFailed(getUserPrefs.getException());
            }
        });
        return request;
    }

    protected <T> BasicResult putInternalArrayList(String key, ArrayList<T> values, BasicResultCallback callback) {
        JSONArray jsonArray = new JSONArray();
        for (T value : values) {
            jsonArray.put(value);
        }
        return this.update(this.context, key, jsonArray, callback);
    }

    protected BasicResult update(@NonNull Context context, String key, RequestBody value, BasicResultCallback callback, PreferencesType preferencesType) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        BasicResult request = new BasicResult(callback, this.handler, executorService);
        executorService.execute(() -> {
            Result putUserPrefs;
            String methodIdentifier = "UserPreference.update";
            String url = "/kernel/userpref/" + key;
            Buffer buffer = new Buffer();
            try {
                value.writeTo((BufferedSink)buffer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String newString = buffer.readUtf8();
            if (preferencesType == PreferencesType.IS_STRING) {
                try {
                    new JSONObject(newString);
                    putUserPrefs = FlyAway.put(context, url, newString, null, "UserPreference.update", null);
                }
                catch (JSONException e) {
                    try {
                        new JSONArray(newString);
                        putUserPrefs = FlyAway.put(context, url, newString, null, "UserPreference.update", null);
                    }
                    catch (JSONException ignored) {
                        putUserPrefs = FlyAway.put(context, url, "\"" + newString + "\"", null, "UserPreference.update", null);
                    }
                }
            } else {
                putUserPrefs = FlyAway.put(context, url, value, null, "UserPreference.update", null);
            }
            if (putUserPrefs.getStatus() == RequestStatus.NOT_FOUND) {
                Result createUserPrefs;
                if (preferencesType == PreferencesType.IS_STRING) {
                    try {
                        new JSONObject(newString);
                        createUserPrefs = FlyAway.post(context, url, newString, null, "UserPreference.update", null);
                    }
                    catch (JSONException e) {
                        try {
                            new JSONArray(newString);
                            createUserPrefs = FlyAway.post(context, url, newString, null, "UserPreference.update", null);
                        }
                        catch (JSONException ignored) {
                            createUserPrefs = FlyAway.post(context, url, "\"" + newString + "\"", null, "UserPreference.update", null);
                        }
                    }
                } else {
                    createUserPrefs = FlyAway.post(context, url, value, null, "UserPreference.update", null);
                }
                if (createUserPrefs.getStatus() == RequestStatus.NOT_FOUND) {
                    JSONObject rootObject = new JSONObject();
                    JSONObject object = new JSONObject();
                    try {
                        switch (preferencesType.ordinal()) {
                            case 0: {
                                object.put(key, Integer.parseInt(newString));
                                break;
                            }
                            case 2: {
                                object.put(key, Boolean.parseBoolean(newString));
                                break;
                            }
                            case 6: {
                                object.put(key, Double.parseDouble(newString));
                                break;
                            }
                            case 5: {
                                object.put(key, Long.parseLong(newString));
                                break;
                            }
                            case 4: {
                                object.put(key, (Object)new JSONArray(newString));
                                break;
                            }
                            case 1: 
                            case 3: {
                                try {
                                    object.put(key, (Object)new JSONObject(newString));
                                    break;
                                }
                                catch (JSONException e) {
                                    try {
                                        object.put(key, (Object)new JSONArray(newString));
                                        break;
                                    }
                                    catch (JSONException ex) {
                                        object.put(key, (Object)newString);
                                    }
                                }
                            }
                        }
                        rootObject.put("data", (Object)object);
                    }
                    catch (JSONException e) {
                        Logger.appendTag(TAG).e("JsonException thrown");
                    }
                    String body2 = rootObject.toString();
                    Result createRootUserPrefs = FlyAway.post(context, API_USER_PREF, body2, null, "UserPreference.update", null);
                    request.setResult(createRootUserPrefs);
                } else {
                    request.setResult(createUserPrefs);
                }
            } else if (putUserPrefs.getException() != null && putUserPrefs.getStatus() != RequestStatus.NOT_FOUND) {
                request.setFailed(putUserPrefs.getException());
            } else {
                request.setResult(putUserPrefs);
            }
        });
        return request;
    }

    protected BasicResult update(@NonNull Context context, final String key, final JSONArray value, BasicResultCallback callback) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        final BasicResult request = new BasicResult(callback, this.handler, executorService);
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                request.setResult(FlybitsPreferences.this.update(key, value));
            }
        });
        return request;
    }

    protected Result update(String key, JSONArray value) {
        String methodIdentifier = "UserPreference.update";
        String url = "/kernel/userpref/" + key;
        Result putUserPrefs = FlyAway.put(this.context, url, value.toString(), null, methodIdentifier, null);
        if (putUserPrefs.getStatus() == RequestStatus.NOT_FOUND) {
            Result createUserPrefs = FlyAway.post(this.context, url, value.toString(), null, methodIdentifier, null);
            if (createUserPrefs.getStatus() == RequestStatus.NOT_FOUND) {
                JSONObject rootObject = new JSONObject();
                try {
                    JSONObject object = new JSONObject();
                    object.put(key, (Object)value);
                    rootObject.put("data", (Object)object);
                }
                catch (JSONException object) {
                    // empty catch block
                }
                String body2 = rootObject.toString();
                Result createRootUserPrefs = FlyAway.post(this.context, API_USER_PREF, body2, null, methodIdentifier, null);
                return createRootUserPrefs;
            }
            return createUserPrefs;
        }
        return putUserPrefs;
    }

    protected static enum PreferencesType {
        IS_INTEGER,
        IS_STRING,
        IS_BOOLEAN,
        IS_OBJECT,
        IS_OBJECT_LIST,
        IS_LONG,
        IS_DOUBLE;

    }
}

