/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.caching;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import com.flybits.commons.library.logging.Logger;

public abstract class FlybitsUIObjectObserver<T> {
    private final String TAG = "FlyObserver";
    private DataChanged<T> callback;
    private LiveData<T> item;
    private Observer<T> observer;

    protected void add(DataChanged<T> callback) {
        this.callback = callback;
    }

    @Nullable
    protected LiveData<T> getData() {
        return this.item;
    }

    @SuppressLint(value={"RestrictedApi"})
    public void remove() {
        if (ArchTaskExecutor.getInstance().isMainThread()) {
            if (this.item != null && this.item.hasActiveObservers()) {
                this.item.removeObserver(this.observer);
                Logger.appendTag("FlyObserver").d("Successfully removed observer.");
            }
        } else {
            Logger.appendTag("FlyObserver").e("Cannot invoke removeObserver on a background thread");
        }
    }

    protected void setItem(LiveData<T> item) {
        this.item = item;
        this.observer = t -> {
            if (this.callback != null) {
                this.callback.onUpdate(t);
            }
        };
        Logger.appendTag("FlyObserver").d("Successfully set an observer.");
        new Handler(Looper.getMainLooper()).post(() -> this.item.observeForever(this.observer));
    }

    public static interface DataChanged<T> {
        public void onUpdate(@Nullable T var1);
    }
}

