package com.flybits.commons.library.deserializations;

import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.logging.Logger;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

import androidx.annotation.Nullable;

public abstract class IDeserializer<T> {

    public static final String KEY_LIST_ITEM = "data";
    public static final String KEY_PAGING = "pagination";

    public abstract String toJson(T obj);

    public @Nullable T fromJson(String json) {
        try {
            Object jsonObject = new JSONTokener(json).nextValue();
            if (jsonObject instanceof JSONObject) {
                JSONObject jObject = new JSONObject(json);
                return fromJson(jObject);
            } else if (jsonObject instanceof JSONArray) {
                JSONArray jObject = new JSONArray(json);
                return fromJson(jObject);
            }
        } catch (JSONException | NullPointerException e) {
            Logger.appendTag(FlyAway.TAG).e("Exception encountered:", e);
        }
        return null;
    }

    public abstract T fromJson(JSONObject jsonObject);

    public abstract T fromJson(JSONArray jsonObject);
}
