/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.utils.jbool_expressions;

import com.flybits.commons.library.utils.jbool_expressions.Rule;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Expression<K>
implements Serializable {
    public static final Comparator<Expression> HASH_COMPARATOR = new HashComparator();
    public static final Comparator<Expression> LEXICOGRAPHIC_COMPARATOR = new LexicographicComparator();

    public abstract Expression<K> apply(List<Rule<?, K>> var1);

    public abstract String getExprType();

    public abstract Expression<K> sort(Comparator<Expression> var1);

    public String toLexicographicString() {
        return this.sort(LEXICOGRAPHIC_COMPARATOR).toString();
    }

    public Set<K> getAllK() {
        HashSet variables = new HashSet();
        this.collectK(variables, Integer.MAX_VALUE);
        return variables;
    }

    public abstract void collectK(Set<K> var1, int var2);

    public abstract Expression<K> replaceVars(Map<K, Expression<K>> var1);

    public static class HashComparator
    implements Comparator<Expression> {
        @Override
        public int compare(Expression o1, Expression o2) {
            if (o1 == o2) {
                return 0;
            }
            int compare = Integer.compare(o1.hashCode(), o2.hashCode());
            if (compare == 0 && !o1.equals(o2)) {
                return LEXICOGRAPHIC_COMPARATOR.compare(o1, o2);
            }
            return compare;
        }
    }

    public static class LexicographicComparator
    implements Comparator<Expression> {
        @Override
        public int compare(Expression o1, Expression o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

