/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.encryption;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import com.flybits.commons.library.encryption.EncryptionManager;
import com.flybits.commons.library.encryption.RecoveryHandler;
import com.flybits.commons.library.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 /2\u00020\u0001:\u0005/0123B-\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0096\u0002J\f\u0010\u0015\u001a\u00060\u0016R\u00020\u0000H\u0016J\u0016\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018H\u0016J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0013H\u0016J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0014\u001a\u00020\u0005J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\"H\u0016J\u001c\u0010#\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0016J(\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010%2\u0006\u0010\u0014\u001a\u00020\u00052\u000e\u0010&\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010%H\u0016J\u0010\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0005H\u0002J\u0010\u0010)\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016R\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/flybits/commons/library/encryption/SecuredPreferenceStore;", "Landroid/content/SharedPreferences;", "appContext", "Landroid/content/Context;", "storeName", "", "keyPrefix", "bitShiftingKey", "", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;[B)V", "RESERVED_KEYS", "", "[Ljava/lang/String;", "encryptionManager", "Lcom/flybits/commons/library/encryption/EncryptionManager;", "getEncryptionManager", "()Lcom/flybits/commons/library/encryption/EncryptionManager;", "mPrefs", "contains", "", "key", "edit", "Lcom/flybits/commons/library/encryption/SecuredPreferenceStore$Editor;", "getAll", "", "", "getBoolean", "defValue", "getBytes", "getFloat", "", "getInt", "", "getLong", "", "getString", "getStringSet", "", "defValues", "isReservedHashedKey", "hashedKey", "isReservedKey", "registerOnSharedPreferenceChangeListener", "", "onSharedPreferenceChangeListener", "Landroid/content/SharedPreferences$OnSharedPreferenceChangeListener;", "unregisterOnSharedPreferenceChangeListener", "Companion", "Editor", "KeyStoreRecoveryNotifier", "MigrationFailedException", "MigrationHelper", "commons_release"})
public final class SecuredPreferenceStore
implements SharedPreferences {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] RESERVED_KEYS;
    @NotNull
    private final SharedPreferences mPrefs;
    @NotNull
    private final EncryptionManager encryptionManager;
    @NotNull
    private static final int[] VERSIONS_WITH_BREAKING_CHANGES;
    @NotNull
    public static final String VERSION_KEY = "VERSION";
    @NotNull
    private static final String DEFAULT_PREF_FILE_NAME = "SPS_file";
    @Nullable
    private static RecoveryHandler mRecoveryHandler;
    @Nullable
    private static SecuredPreferenceStore mInstance;

    @NotNull
    public final EncryptionManager getEncryptionManager() {
        return this.encryptionManager;
    }

    private final boolean isReservedKey(String key) {
        String[] stringArray = this.RESERVED_KEYS;
        return CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length)).contains(key);
    }

    private final boolean isReservedHashedKey(String hashedKey) {
        for (String key : this.RESERVED_KEYS) {
            try {
                if (!Intrinsics.areEqual((Object)hashedKey, (Object)EncryptionManager.Companion.getHashed(key))) continue;
                return true;
            }
            catch (NoSuchAlgorithmException e) {
                Logger.appendTag("flybits_encryption").e("", e);
            }
            catch (UnsupportedEncodingException e) {
                Logger.appendTag("flybits_encryption").e("throw excpetion", e);
            }
        }
        return false;
    }

    @NotNull
    public Map<String, Object> getAll() {
        Map all = this.mPrefs.getAll();
        Map dAll = new HashMap(all.size());
        if (all.size() > 0) {
            for (String key : all.keySet()) {
                if (Intrinsics.areEqual((Object)key, (Object)VERSION_KEY)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                if (this.isReservedHashedKey(key)) continue;
                try {
                    Object value = all.get(key);
                    dAll.put(key, this.encryptionManager.decrypt$commons_release((String)value));
                }
                catch (Exception e) {
                    Logger.appendTag("flybits_encryption").e("throw excpetion", e);
                }
            }
        }
        return dAll;
    }

    @Nullable
    public String getString(@NotNull String key, @Nullable String defValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!this.isReservedKey(key)) {
            try {
                String hashedKey = EncryptionManager.Companion.getHashed(key);
                String value = this.mPrefs.getString(hashedKey, null);
                if (value != null) {
                    return this.encryptionManager.decrypt$commons_release(value);
                }
            }
            catch (Exception e) {
                Logger.appendTag("flybits_encryption").e("throw excpetion", e);
            }
        }
        return defValue;
    }

    @Nullable
    public Set<String> getStringSet(@NotNull String key, @Nullable Set<String> defValues) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!this.isReservedKey(key)) {
            try {
                String hashedKey = EncryptionManager.Companion.getHashed(key);
                Set eSet = this.mPrefs.getStringSet(hashedKey, null);
                if (eSet != null) {
                    Set dSet = new HashSet(eSet.size());
                    for (String val : eSet) {
                        String toAdd;
                        if (this.encryptionManager.decrypt$commons_release(val) == null) continue;
                        dSet.add(toAdd);
                    }
                    return dSet;
                }
            }
            catch (Exception e) {
                Logger.appendTag("flybits_encryption").e("throw excpetion", e);
            }
        }
        return defValues;
    }

    public int getInt(@NotNull String key, int defValue) {
        String value;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = value = this.getString(key, null);
        return string != null ? Integer.parseInt(string) : defValue;
    }

    public long getLong(@NotNull String key, long defValue) {
        String value;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = value = this.getString(key, null);
        return string != null ? Long.parseLong(string) : defValue;
    }

    public float getFloat(@NotNull String key, float defValue) {
        String value;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = value = this.getString(key, null);
        return string != null ? Float.parseFloat(string) : defValue;
    }

    public boolean getBoolean(@NotNull String key, boolean defValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String value = this.getString(key, null);
        return value != null ? Boolean.parseBoolean(value) : defValue;
    }

    @Nullable
    public final byte[] getBytes(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String val = this.getString(key, null);
        return val != null ? EncryptionManager.Companion.base64Decode(val) : null;
    }

    public boolean contains(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            String hashedKey = EncryptionManager.Companion.getHashed(key);
            return this.mPrefs.contains(hashedKey);
        }
        catch (Exception e) {
            Logger.appendTag("flybits_encryption").e("throw excpetion", e);
            return false;
        }
    }

    @NotNull
    public Editor edit() {
        return new Editor();
    }

    public void registerOnSharedPreferenceChangeListener(@NotNull SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
        Intrinsics.checkNotNullParameter((Object)onSharedPreferenceChangeListener, (String)"onSharedPreferenceChangeListener");
        this.mPrefs.registerOnSharedPreferenceChangeListener(onSharedPreferenceChangeListener);
    }

    public void unregisterOnSharedPreferenceChangeListener(@NotNull SharedPreferences.OnSharedPreferenceChangeListener onSharedPreferenceChangeListener) {
        Intrinsics.checkNotNullParameter((Object)onSharedPreferenceChangeListener, (String)"onSharedPreferenceChangeListener");
        this.mPrefs.unregisterOnSharedPreferenceChangeListener(onSharedPreferenceChangeListener);
    }

    private SecuredPreferenceStore(Context appContext, String storeName, String keyPrefix, byte[] bitShiftingKey) {
        Logger.d("Creating store instance");
        String string = storeName;
        if (string == null) {
            string = DEFAULT_PREF_FILE_NAME;
        }
        String fileName = string;
        SharedPreferences sharedPreferences = appContext.getSharedPreferences(fileName, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"appContext.getSharedPref\u2026me, Context.MODE_PRIVATE)");
        this.mPrefs = sharedPreferences;
        this.encryptionManager = new EncryptionManager(appContext, this.mPrefs, keyPrefix, bitShiftingKey, new KeyStoreRecoveryNotifier(){

            @Override
            public boolean onRecoveryRequired(@NotNull Exception e, @Nullable KeyStore keyStore, @Nullable List<String> keyAliases) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                RecoveryHandler recoveryHandler = mRecoveryHandler;
                if (recoveryHandler == null) {
                    throw new RuntimeException(e);
                }
                return recoveryHandler.recover(e, keyStore, keyAliases, mPrefs);
            }
        });
        String[] stringArray = new String[]{VERSION_KEY, "OverridingAlias", this.encryptionManager.getIS_COMPAT_MODE_KEY_ALIAS(), this.encryptionManager.getMAC_KEY_ALIAS(), this.encryptionManager.getAES_KEY_ALIAS()};
        this.RESERVED_KEYS = stringArray;
    }

    public /* synthetic */ SecuredPreferenceStore(Context appContext, String storeName, String keyPrefix, byte[] bitShiftingKey, DefaultConstructorMarker $constructor_marker) {
        this(appContext, storeName, keyPrefix, bitShiftingKey);
    }

    static {
        int[] nArray = new int[]{10};
        VERSIONS_WITH_BREAKING_CHANGES = nArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0001H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0018\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0016J \u0010\u001b\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0003\u001a\u00020\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lcom/flybits/commons/library/encryption/SecuredPreferenceStore$Editor;", "Landroid/content/SharedPreferences$Editor;", "(Lcom/flybits/commons/library/encryption/SecuredPreferenceStore;)V", "mEditor", "getMEditor", "()Landroid/content/SharedPreferences$Editor;", "setMEditor", "(Landroid/content/SharedPreferences$Editor;)V", "apply", "", "clear", "commit", "", "putBoolean", "key", "", "value", "putBytes", "bytes", "", "putFloat", "", "putInt", "", "putLong", "", "putString", "putStringSet", "values", "", "remove", "commons_release"})
    public final class Editor
    implements SharedPreferences.Editor {
        @NotNull
        private SharedPreferences.Editor mEditor;

        public Editor() {
            SharedPreferences.Editor editor = SecuredPreferenceStore.this.mPrefs.edit();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"mPrefs.edit()");
            this.mEditor = editor;
        }

        @NotNull
        public final SharedPreferences.Editor getMEditor() {
            return this.mEditor;
        }

        public final void setMEditor(@NotNull SharedPreferences.Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"<set-?>");
            this.mEditor = editor;
        }

        @NotNull
        public SharedPreferences.Editor putString(@NotNull String key, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (SecuredPreferenceStore.this.isReservedKey(key)) {
                Logger.e("Trying to store value for a reserved key, value: " + value);
                return this;
            }
            try {
                String hashedKey = EncryptionManager.Companion.getHashed(key);
                String evalue = SecuredPreferenceStore.this.getEncryptionManager().encrypt$commons_release(value);
                this.mEditor.putString(hashedKey, evalue);
            }
            catch (Exception e) {
                Logger.appendTag("flybits_encryption").e("throw excpetion", e);
            }
            return this;
        }

        @NotNull
        public SharedPreferences.Editor putStringSet(@NotNull String key, @Nullable Set<String> values) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (SecuredPreferenceStore.this.isReservedKey(key)) {
                Logger.e("Trying to store value for a reserved key, value: " + values);
                return this;
            }
            Collection collection = values;
            if (collection == null || collection.isEmpty()) {
                Logger.e("flybits_encryption putStringSet values is null or empty");
                return this;
            }
            try {
                String hashedKey = EncryptionManager.Companion.getHashed(key);
                Set eSet = new HashSet(values.size());
                for (String val : values) {
                    eSet.add(SecuredPreferenceStore.this.getEncryptionManager().encrypt$commons_release(val));
                }
                this.mEditor.putStringSet(hashedKey, eSet);
            }
            catch (Exception e) {
                Logger.appendTag("flybits_encryption").e("throw excpetion", e);
            }
            return this;
        }

        @NotNull
        public SharedPreferences.Editor putInt(@NotNull String key, int value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String val = Integer.toString(value);
            return this.putString(key, val);
        }

        @NotNull
        public SharedPreferences.Editor putLong(@NotNull String key, long value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String val = Long.toString(value);
            return this.putString(key, val);
        }

        @NotNull
        public SharedPreferences.Editor putFloat(@NotNull String key, float value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String val = Float.toString(value);
            return this.putString(key, val);
        }

        @NotNull
        public SharedPreferences.Editor putBoolean(@NotNull String key, boolean value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            String val = Boolean.toString(value);
            return this.putString(key, val);
        }

        @NotNull
        public final SharedPreferences.Editor putBytes(@NotNull String key, @Nullable byte[] bytes) {
            SharedPreferences.Editor editor;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (bytes != null) {
                String val = EncryptionManager.Companion.base64Encode(bytes);
                editor = this.putString(key, val);
            } else {
                editor = this.remove(key);
            }
            return editor;
        }

        @NotNull
        public SharedPreferences.Editor remove(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (SecuredPreferenceStore.this.isReservedKey(key)) {
                Logger.e("Trying to remove value for a reserved key");
                return this;
            }
            try {
                String hashedKey = EncryptionManager.Companion.getHashed(key);
                this.mEditor.remove(hashedKey);
            }
            catch (Exception e) {
                Logger.appendTag("flybits_encryption").e("throw excpetion", e);
            }
            return this;
        }

        @NotNull
        public SharedPreferences.Editor clear() {
            for (String key : SecuredPreferenceStore.this.mPrefs.getAll().keySet()) {
                if (Intrinsics.areEqual((Object)key, (Object)SecuredPreferenceStore.VERSION_KEY)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                if (SecuredPreferenceStore.this.isReservedHashedKey(key)) continue;
                this.mEditor.remove(key);
            }
            return this;
        }

        public boolean commit() {
            return this.mEditor.commit();
        }

        public void apply() {
            this.mEditor.apply();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J0\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0010\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\nH&\u00a8\u0006\f"}, d2={"Lcom/flybits/commons/library/encryption/SecuredPreferenceStore$KeyStoreRecoveryNotifier;", "", "onRecoveryRequired", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "keyStore", "Ljava/security/KeyStore;", "keyAliases", "", "", "commons_release"})
    public static interface KeyStoreRecoveryNotifier {
        public boolean onRecoveryRequired(@NotNull Exception var1, @Nullable KeyStore var2, @Nullable List<String> var3);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001e\u001a\u00020\u0019R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/flybits/commons/library/encryption/SecuredPreferenceStore$MigrationHelper;", "", "mContext", "Landroid/content/Context;", "storeName", "", "keyPrefix", "bitShiftKey", "", "(Lcom/flybits/commons/library/encryption/SecuredPreferenceStore;Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;[B)V", "getBitShiftKey", "()[B", "setBitShiftKey", "([B)V", "getKeyPrefix", "()Ljava/lang/String;", "setKeyPrefix", "(Ljava/lang/String;)V", "getMContext", "()Landroid/content/Context;", "setMContext", "(Landroid/content/Context;)V", "getStoreName", "setStoreName", "cleanupPref", "", "migrate", "toVersion", "", "fromVersion", "migrateToV10", "commons_release"})
    private final class MigrationHelper {
        @NotNull
        private Context mContext;
        @Nullable
        private String storeName;
        @Nullable
        private String keyPrefix;
        @Nullable
        private byte[] bitShiftKey;

        public MigrationHelper(@Nullable Context mContext, @Nullable String storeName, @Nullable String keyPrefix, byte[] bitShiftKey) {
            Intrinsics.checkNotNullParameter((Object)mContext, (String)"mContext");
            this.mContext = mContext;
            this.storeName = storeName;
            this.keyPrefix = keyPrefix;
            this.bitShiftKey = bitShiftKey;
        }

        @NotNull
        public final Context getMContext() {
            return this.mContext;
        }

        public final void setMContext(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
            this.mContext = context;
        }

        @Nullable
        public final String getStoreName() {
            return this.storeName;
        }

        public final void setStoreName(@Nullable String string) {
            this.storeName = string;
        }

        @Nullable
        public final String getKeyPrefix() {
            return this.keyPrefix;
        }

        public final void setKeyPrefix(@Nullable String string) {
            this.keyPrefix = string;
        }

        @Nullable
        public final byte[] getBitShiftKey() {
            return this.bitShiftKey;
        }

        public final void setBitShiftKey(@Nullable byte[] byArray) {
            this.bitShiftKey = byArray;
        }

        public final void migrateToV10() throws MigrationFailedException {
            String string;
            if (this.storeName == null && this.keyPrefix == null && this.bitShiftKey == null) {
                return;
            }
            SharedPreferences prefToRead = null;
            SharedPreferences prefToWrite = null;
            SharedPreferences sharedPreferences = this.mContext.getSharedPreferences(SecuredPreferenceStore.DEFAULT_PREF_FILE_NAME, 0);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"mContext.getSharedPrefer\u2026ODE_PRIVATE\n            )");
            prefToRead = prefToWrite = sharedPreferences;
            boolean filenameChanged = false;
            boolean prefixChanged = false;
            if (this.storeName != null && !Intrinsics.areEqual((Object)this.storeName, (Object)SecuredPreferenceStore.DEFAULT_PREF_FILE_NAME)) {
                SharedPreferences sharedPreferences2 = this.mContext.getSharedPreferences(this.storeName, 0);
                Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences2, (String)"mContext.getSharedPrefer\u2026me, Context.MODE_PRIVATE)");
                prefToWrite = sharedPreferences2;
                filenameChanged = true;
            }
            String storedPrefix = null;
            try {
                string = prefToWrite.getString(EncryptionManager.Companion.getHashed("OverridingAlias"), null);
            }
            catch (NoSuchAlgorithmException e) {
                throw new MigrationFailedException("Migration to Version: 0.7.0: Failed to hash a key", e);
            }
            catch (UnsupportedEncodingException e) {
                throw new MigrationFailedException("Migration to Version: 0.7.0: Failed to hash a key", e);
            }
            storedPrefix = string;
            boolean bl = prefixChanged = storedPrefix == null && this.keyPrefix != null && !Intrinsics.areEqual((Object)this.keyPrefix, (Object)"sps");
            if ((filenameChanged || prefixChanged) && prefToRead.getAll().size() > 0) {
                try {
                    EncryptionManager readCrypto = new EncryptionManager(this.mContext, prefToRead, this.keyPrefix, this.bitShiftKey, null);
                    EncryptionManager writeCrypto = new EncryptionManager(this.mContext, prefToWrite, this.keyPrefix, this.bitShiftKey, null);
                    Map allData = prefToRead.getAll();
                    SharedPreferences.Editor editor = prefToWrite.edit();
                    Intrinsics.checkNotNullExpressionValue((Object)allData, (String)"allData");
                    for (Map.Entry entry : allData.entrySet()) {
                        String hashedKey = (String)entry.getKey();
                        Object value1 = entry.getValue();
                        if (Intrinsics.areEqual((Object)hashedKey, (Object)EncryptionManager.Companion.getHashed(readCrypto.getAES_KEY_ALIAS())) || Intrinsics.areEqual((Object)hashedKey, (Object)EncryptionManager.Companion.getHashed(readCrypto.getIS_COMPAT_MODE_KEY_ALIAS())) || Intrinsics.areEqual((Object)hashedKey, (Object)EncryptionManager.Companion.getHashed(readCrypto.getMAC_KEY_ALIAS())) || value1 == null) continue;
                        Object v = value1;
                        if (v instanceof Set) {
                            Set values = (Set)value1;
                            Set eValues = new HashSet();
                            for (String value : values) {
                                String dValue = readCrypto.decrypt$commons_release(value);
                                eValues.add(writeCrypto.encrypt$commons_release(dValue));
                            }
                            editor.putStringSet(hashedKey, eValues);
                            continue;
                        }
                        if (v instanceof String) {
                            String dValue = readCrypto.decrypt$commons_release((String)value1);
                            editor.putString(hashedKey, writeCrypto.encrypt$commons_release(dValue));
                            continue;
                        }
                        Logger.e("Found a value that is not String or Set, key: " + hashedKey + ", value: " + value1);
                    }
                    if (editor.commit()) {
                        editor.putInt(SecuredPreferenceStore.VERSION_KEY, 10).apply();
                        this.cleanupPref(SecuredPreferenceStore.DEFAULT_PREF_FILE_NAME);
                    }
                }
                catch (InvalidKeyException e) {
                    throw new MigrationFailedException("Migration to Version: 0.7.0: Encryption/Hashing Error", e);
                }
                catch (UnrecoverableEntryException e) {
                    throw new MigrationFailedException("Migration to Version: 0.7.0: Encryption/Hashing Error", e);
                }
                catch (KeyStoreException e) {
                    throw new MigrationFailedException("Migration to Version: 0.7.0: Encryption/Hashing Error", e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new MigrationFailedException("Migration to Version: 0.7.0: Encryption/Hashing Error", e);
                }
                catch (NoSuchProviderException e) {
                    throw new MigrationFailedException("Migration to Version: 0.7.0: Encryption/Hashing Error", e);
                }
                catch (CertificateException e) {
                    throw new MigrationFailedException("Migration to Version: 0.7.0: Encryption/Hashing Error", e);
                }
                catch (UnsupportedEncodingException e) {
                    throw new MigrationFailedException("Migration to Version: 0.7.0: Encryption/Hashing Error", e);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new MigrationFailedException("Migration to Version: 0.7.0: Encryption/Hashing Error", e);
                }
                catch (EncryptionManager.InvalidMacException e) {
                    throw new MigrationFailedException("Migration to Version: 0.7.0: Encryption/Hashing Error", e);
                }
                catch (IllegalBlockSizeException e) {
                    throw new MigrationFailedException("Migration to Version: 0.7.0: Encryption/Hashing Error", e);
                }
                catch (BadPaddingException e) {
                    throw new MigrationFailedException("Migration to Version: 0.7.0: Encryption/Hashing Error", e);
                }
                catch (NoSuchPaddingException e) {
                    throw new MigrationFailedException("Migration to Version: 0.7.0: Encryption/Hashing Error", e);
                }
                catch (IOException e) {
                    throw new MigrationFailedException("Migration to Version: 0.7.0: Encryption/Hashing Error", e);
                }
            }
        }

        public final void migrate(int fromVersion, int toVersion) throws MigrationFailedException {
            int fromVersion2 = fromVersion;
            if (fromVersion2 >= toVersion) {
                return;
            }
            for (int version : VERSIONS_WITH_BREAKING_CHANGES) {
                if (fromVersion2 >= version) continue;
                this.migrate(version);
                fromVersion2 = version;
            }
            SecuredPreferenceStore.this.mPrefs.edit().putInt(SecuredPreferenceStore.VERSION_KEY, toVersion).apply();
        }

        public final void migrate(int toVersion) throws MigrationFailedException {
            if (toVersion == 10) {
                Logger.d("Migrating to: " + toVersion);
                this.migrateToV10();
            }
        }

        public final void cleanupPref(@NotNull String storeName) {
            Intrinsics.checkNotNullParameter((Object)storeName, (String)"storeName");
            SharedPreferences prefs = this.mContext.getSharedPreferences(storeName, 0);
            if (prefs.getAll().size() > 0) {
                prefs.edit().clear().commit();
            }
            if (Build.VERSION.SDK_INT >= 24) {
                this.mContext.deleteSharedPreferences(storeName);
            } else {
                try {
                    new File(this.mContext.getCacheDir().getParent() + "/shared_prefs/" + storeName + ".xml").delete();
                }
                catch (Exception e) {
                    Logger.w("Unable to remove store file completely");
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/flybits/commons/library/encryption/SecuredPreferenceStore$MigrationFailedException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "cause", "", "(Lcom/flybits/commons/library/encryption/SecuredPreferenceStore;Ljava/lang/String;Ljava/lang/Throwable;)V", "commons_release"})
    public final class MigrationFailedException
    extends Exception {
        public MigrationFailedException(@Nullable String message, Throwable cause) {
            super(message, cause);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u0004\u0018\u00010\tJ6\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/flybits/commons/library/encryption/SecuredPreferenceStore$Companion;", "", "()V", "DEFAULT_PREF_FILE_NAME", "", "VERSIONS_WITH_BREAKING_CHANGES", "", "VERSION_KEY", "mInstance", "Lcom/flybits/commons/library/encryption/SecuredPreferenceStore;", "mRecoveryHandler", "Lcom/flybits/commons/library/encryption/RecoveryHandler;", "getSharedInstance", "init", "", "appContext", "Landroid/content/Context;", "storeName", "keyPrefix", "bitShiftingKey", "", "recoveryHandler", "setRecoveryHandler", "commons_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void setRecoveryHandler(@Nullable RecoveryHandler recoveryHandler) {
            mRecoveryHandler = recoveryHandler;
        }

        @Nullable
        public final synchronized SecuredPreferenceStore getSharedInstance() {
            if (mInstance == null) {
                boolean bl = false;
                String string = "Must call init() before using the store";
                throw new IllegalStateException(string.toString());
            }
            return mInstance;
        }

        public final void init(@NotNull Context appContext, @Nullable String storeName, @Nullable String keyPrefix, @Nullable byte[] bitShiftingKey, @Nullable RecoveryHandler recoveryHandler) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableEntryException, InvalidAlgorithmParameterException, NoSuchPaddingException, InvalidKeyException, NoSuchProviderException, MigrationFailedException {
            Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
            if (mInstance != null) {
                Logger.w("init called when there already is a non-null instance of the class");
                return;
            }
            this.setRecoveryHandler(recoveryHandler);
            mInstance = new SecuredPreferenceStore(appContext, storeName, keyPrefix, bitShiftingKey, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

