/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.encryption;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.security.keystore.KeyGenParameterSpec;
import android.util.Base64;
import com.flybits.commons.library.encryption.SecuredPreferenceStore;
import com.flybits.commons.library.logging.Logger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.security.auth.x500.X500Principal;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u0000 ^2\u00020\u0001:\u0003^_`B#\b\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB5\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\nH\u0002J\u0019\u00106\u001a\u0004\u0018\u00010\f2\b\u00107\u001a\u0004\u0018\u000104H\u0000\u00a2\u0006\u0002\b8J\u0019\u00106\u001a\u0004\u0018\u00010\n2\b\u00105\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\b8J\u0015\u00109\u001a\u00020\f2\u0006\u0010:\u001a\u000204H\u0001\u00a2\u0006\u0002\b;J\u0010\u0010<\u001a\u00020\n2\u0006\u00107\u001a\u000204H\u0002J\u0019\u0010=\u001a\u0004\u0018\u0001042\b\u0010>\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\b?J\u0019\u0010=\u001a\u0004\u0018\u00010\n2\b\u00105\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\b?J#\u0010@\u001a\u0004\u0018\u0001042\b\u0010>\u001a\u0004\u0018\u00010\f2\b\u0010A\u001a\u0004\u0018\u00010\fH\u0001\u00a2\u0006\u0002\bBJ\u0012\u0010C\u001a\u00020D2\b\u0010E\u001a\u0004\u0018\u00010\fH\u0003J)\u0010F\u001a\u00020D2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010E\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bGJ\u001a\u0010H\u001a\u00020I2\b\u0010A\u001a\u0004\u0018\u00010\f2\u0006\u0010J\u001a\u00020DH\u0003J'\u0010K\u001a\u00020D\"\u0010\b\u0000\u0010L*\n\u0018\u00010Mj\u0004\u0018\u0001`N2\u0006\u0010O\u001a\u0002HLH\u0002\u00a2\u0006\u0002\u0010PJ\u0010\u0010Q\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0RH\u0002J\u0015\u0010S\u001a\u00020T2\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bUJ\b\u0010V\u001a\u00020TH\u0002J$\u0010W\u001a\u00020T2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010E\u001a\u0004\u0018\u00010\fH\u0002J\u0019\u0010X\u001a\u0004\u0018\u00010\f2\b\u00107\u001a\u0004\u0018\u000104H\u0000\u00a2\u0006\u0002\bYJ\u0019\u0010Z\u001a\u0004\u0018\u0001042\b\u0010>\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\b[J#\u0010\\\u001a\u00020D\"\f\b\u0000\u0010L*\u00060Mj\u0002`N2\u0006\u0010]\u001a\u0002HLH\u0002\u00a2\u0006\u0002\u0010PR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0014R\u000e\u0010\u0019\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0014R\u000e\u0010\u001d\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0010\u0010$\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001c\u0010+\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u000e\u00100\u001a\u000201X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lcom/flybits/commons/library/encryption/EncryptionManager;", "", "context", "Landroid/content/Context;", "prefStore", "Landroid/content/SharedPreferences;", "recoveryNotifier", "Lcom/flybits/commons/library/encryption/SecuredPreferenceStore$KeyStoreRecoveryNotifier;", "(Landroid/content/Context;Landroid/content/SharedPreferences;Lcom/flybits/commons/library/encryption/SecuredPreferenceStore$KeyStoreRecoveryNotifier;)V", "keyAliasPrefix", "", "bitShiftingKey", "", "recoveryHandler", "(Landroid/content/Context;Landroid/content/SharedPreferences;Ljava/lang/String;[BLcom/flybits/commons/library/encryption/SecuredPreferenceStore$KeyStoreRecoveryNotifier;)V", "AES_BIT_LENGTH", "", "AES_CIPHER", "AES_KEY_ALIAS", "getAES_KEY_ALIAS", "()Ljava/lang/String;", "DELIMITER", "GCM_TAG_LENGTH", "IS_COMPAT_MODE_KEY_ALIAS", "getIS_COMPAT_MODE_KEY_ALIAS", "IV_LENGTH", "KEYSTORE_PROVIDER", "MAC_KEY_ALIAS", "getMAC_KEY_ALIAS", "RSA_KEY_ALIAS", "SHIFTING_KEY", "aesKey", "Ljavax/crypto/SecretKey;", "iV", "getIV", "()[B", "mContext", "mKeyAliasPrefix", "mPrefs", "getMPrefs", "()Landroid/content/SharedPreferences;", "setMPrefs", "(Landroid/content/SharedPreferences;)V", "mRecoveryHandler", "getMRecoveryHandler", "()Lcom/flybits/commons/library/encryption/SecuredPreferenceStore$KeyStoreRecoveryNotifier;", "setMRecoveryHandler", "(Lcom/flybits/commons/library/encryption/SecuredPreferenceStore$KeyStoreRecoveryNotifier;)V", "mStore", "Ljava/security/KeyStore;", "x500_PRINCIPAL", "decodeEncryptedText", "Lcom/flybits/commons/library/encryption/EncryptionManager$EncryptedData;", "text", "decrypt", "data", "decrypt$commons_release", "decryptAES", "encryptedData", "decryptAES$commons_release", "encodeEncryptedData", "encrypt", "bytes", "encrypt$commons_release", "encryptAES", "IV", "encryptAES$commons_release", "generateAESKey", "", "seed", "generateKey", "generateKey$commons_release", "getCipherAES", "Ljavax/crypto/Cipher;", "modeEncrypt", "isRecoverableError", "T", "Ljava/lang/Exception;", "Lkotlin/Exception;", "error", "(Ljava/lang/Exception;)Z", "keyAliases", "", "loadKey", "", "loadKey$commons_release", "loadKeyStore", "setup", "tryDecrypt", "tryDecrypt$commons_release", "tryEncrypt", "tryEncrypt$commons_release", "tryRecovery", "e", "Companion", "EncryptedData", "InvalidMacException", "commons_release"})
public final class EncryptionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int AES_BIT_LENGTH;
    private final int GCM_TAG_LENGTH;
    private final int IV_LENGTH;
    @NotNull
    private final String KEYSTORE_PROVIDER;
    @Nullable
    private final byte[] SHIFTING_KEY;
    @NotNull
    private final String RSA_KEY_ALIAS;
    @NotNull
    private final String AES_KEY_ALIAS;
    @NotNull
    private final String MAC_KEY_ALIAS;
    @NotNull
    private final String DELIMITER;
    @NotNull
    private final String AES_CIPHER;
    @NotNull
    private final String IS_COMPAT_MODE_KEY_ALIAS;
    private KeyStore mStore;
    @Nullable
    private SecretKey aesKey;
    @NotNull
    private final String mKeyAliasPrefix;
    @Nullable
    private final Context mContext;
    @NotNull
    private SharedPreferences mPrefs;
    @Nullable
    private SecuredPreferenceStore.KeyStoreRecoveryNotifier mRecoveryHandler;
    @NotNull
    private final String x500_PRINCIPAL;
    @NotNull
    private static final String DEFAULT_CHARSET = "UTF-8";
    @NotNull
    private static final String RSA_KEY_ALIAS_NAME = "rsa_key";
    @NotNull
    private static final String AES_KEY_ALIAS_NAME = "aes_key";
    @NotNull
    private static final String MAC_KEY_ALIAS_NAME = "mac_key";
    @NotNull
    public static final String OVERRIDING_KEY_ALIAS_PREFIX_NAME = "OverridingAlias";
    @NotNull
    public static final String DEFAULT_KEY_ALIAS_PREFIX = "sps";
    @NotNull
    private static final String KEY_ALGORITHM_AES = "AES";
    @NotNull
    private static final String BLOCK_MODE_GCM = "GCM";
    @NotNull
    private static final String ENCRYPTION_PADDING_NONE = "NoPadding";
    @NotNull
    private static final String IS_COMPAT_MODE_KEY_ALIAS_NAME = "data_in_compat";

    public EncryptionManager(@Nullable Context context, @NotNull SharedPreferences prefStore, @Nullable String keyAliasPrefix, @Nullable byte[] bitShiftingKey, @Nullable SecuredPreferenceStore.KeyStoreRecoveryNotifier recoveryHandler) {
        Intrinsics.checkNotNullParameter((Object)prefStore, (String)"prefStore");
        this.AES_BIT_LENGTH = 256;
        this.GCM_TAG_LENGTH = 128;
        this.IV_LENGTH = 12;
        this.KEYSTORE_PROVIDER = "AndroidKeyStore";
        this.DELIMITER = "]";
        this.AES_CIPHER = "AES/GCM/NoPadding";
        this.x500_PRINCIPAL = "CN = Flybits, O = Flybits Mobile";
        String keyAliasPrefix2 = keyAliasPrefix;
        this.SHIFTING_KEY = bitShiftingKey;
        keyAliasPrefix2 = prefStore.getString(Companion.getHashed(OVERRIDING_KEY_ALIAS_PREFIX_NAME), keyAliasPrefix2);
        String string = keyAliasPrefix2;
        if (string == null) {
            string = DEFAULT_KEY_ALIAS_PREFIX;
        }
        this.mKeyAliasPrefix = string;
        String string2 = "%s_%s";
        Object[] objectArray = new Object[]{this.mKeyAliasPrefix, IS_COMPAT_MODE_KEY_ALIAS_NAME};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        this.IS_COMPAT_MODE_KEY_ALIAS = string3;
        string2 = "%s_%s";
        objectArray = new Object[]{this.mKeyAliasPrefix, RSA_KEY_ALIAS_NAME};
        String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        this.RSA_KEY_ALIAS = string4;
        string2 = "%s_%s";
        objectArray = new Object[]{this.mKeyAliasPrefix, AES_KEY_ALIAS_NAME};
        String string5 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
        this.AES_KEY_ALIAS = string5;
        string2 = "%s_%s";
        objectArray = new Object[]{this.mKeyAliasPrefix, MAC_KEY_ALIAS_NAME};
        String string6 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(format, *args)");
        this.MAC_KEY_ALIAS = string6;
        this.mRecoveryHandler = recoveryHandler;
        this.mContext = context;
        this.mPrefs = prefStore;
        this.loadKeyStore();
        boolean tryAgain = false;
        try {
            this.setup(context, prefStore, bitShiftingKey);
        }
        catch (Exception ex) {
            if (!this.isRecoverableError(ex)) {
                throw ex;
            }
            tryAgain = this.tryRecovery(ex);
        }
        if (tryAgain) {
            this.setup(context, prefStore, bitShiftingKey);
        }
    }

    @NotNull
    public final String getAES_KEY_ALIAS() {
        return this.AES_KEY_ALIAS;
    }

    @NotNull
    public final String getMAC_KEY_ALIAS() {
        return this.MAC_KEY_ALIAS;
    }

    @NotNull
    public final String getIS_COMPAT_MODE_KEY_ALIAS() {
        return this.IS_COMPAT_MODE_KEY_ALIAS;
    }

    @NotNull
    public final SharedPreferences getMPrefs() {
        return this.mPrefs;
    }

    public final void setMPrefs(@NotNull SharedPreferences sharedPreferences) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"<set-?>");
        this.mPrefs = sharedPreferences;
    }

    @Nullable
    public final SecuredPreferenceStore.KeyStoreRecoveryNotifier getMRecoveryHandler() {
        return this.mRecoveryHandler;
    }

    public final void setMRecoveryHandler(@Nullable SecuredPreferenceStore.KeyStoreRecoveryNotifier keyStoreRecoveryNotifier) {
        this.mRecoveryHandler = keyStoreRecoveryNotifier;
    }

    @Deprecated(message="Use the full constructor for better security on older versions of Android\n      ")
    public EncryptionManager(@Nullable Context context, @NotNull SharedPreferences prefStore, @Nullable SecuredPreferenceStore.KeyStoreRecoveryNotifier recoveryNotifier) {
        Intrinsics.checkNotNullParameter((Object)prefStore, (String)"prefStore");
        this(context, prefStore, null, null, recoveryNotifier);
    }

    private final <T extends Exception> boolean isRecoverableError(T error) {
        return error instanceof KeyStoreException || error instanceof UnrecoverableEntryException || error instanceof InvalidKeyException || error instanceof IllegalStateException || error instanceof IOException && ((IOException)error).getCause() != null && ((IOException)error).getCause() instanceof BadPaddingException;
    }

    private final void setup(Context context, SharedPreferences prefStore, byte[] seed) throws NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableEntryException, NoSuchProviderException, InvalidAlgorithmParameterException, IOException {
        SharedPreferences.Editor editor;
        SharedPreferences.Editor editor2;
        SharedPreferences sharedPreferences;
        boolean keyGenerated = this.generateKey$commons_release(context, seed, prefStore);
        if (keyGenerated && (sharedPreferences = this.mPrefs) != null && (editor2 = sharedPreferences.edit()) != null && (editor = editor2.putString(Companion.getHashed(OVERRIDING_KEY_ALIAS_PREFIX_NAME), this.mKeyAliasPrefix)) != null) {
            editor.commit();
        }
        this.loadKey$commons_release(prefStore);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final <T extends Exception> boolean tryRecovery(T e) {
        if (this.mRecoveryHandler == null) return false;
        SecuredPreferenceStore.KeyStoreRecoveryNotifier keyStoreRecoveryNotifier = this.mRecoveryHandler;
        Intrinsics.checkNotNull((Object)keyStoreRecoveryNotifier);
        KeyStore keyStore = this.mStore;
        if (keyStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStore");
            keyStore = null;
        }
        if (!keyStoreRecoveryNotifier.onRecoveryRequired(e, keyStore, this.keyAliases())) return false;
        return true;
    }

    private final List<String> keyAliases() {
        String[] stringArray = new String[]{this.AES_KEY_ALIAS, this.RSA_KEY_ALIAS};
        List<String> list = Arrays.asList(stringArray);
        Intrinsics.checkNotNullExpressionValue(list, (String)"asList(AES_KEY_ALIAS, RSA_KEY_ALIAS)");
        return list;
    }

    public final /* synthetic */ EncryptedData tryEncrypt$commons_release(byte[] bytes) throws NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IOException, BadPaddingException, IllegalBlockSizeException, NoSuchProviderException, InvalidKeyException, KeyStoreException, UnrecoverableEntryException {
        EncryptedData result = null;
        boolean tryAgain = false;
        try {
            result = this.encrypt$commons_release(bytes);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (!this.isRecoverableError(ex)) {
                throw ex;
            }
            tryAgain = this.tryRecovery(ex);
        }
        if (tryAgain) {
            this.setup(this.mContext, this.mPrefs, null);
            result = this.encrypt$commons_release(bytes);
        }
        return result;
    }

    public final /* synthetic */ byte[] tryDecrypt$commons_release(EncryptedData data) throws NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, KeyStoreException, UnrecoverableEntryException, NoSuchProviderException, InvalidKeyException, IOException, BadPaddingException, IllegalBlockSizeException, InvalidMacException {
        byte[] result = null;
        boolean tryAgain = false;
        try {
            result = this.decrypt$commons_release(data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (!this.isRecoverableError(ex)) {
                throw ex;
            }
            tryAgain = this.tryRecovery(ex);
        }
        try {
            if (tryAgain) {
                this.setup(this.mContext, this.mPrefs, null);
                result = this.decrypt$commons_release(data);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public final /* synthetic */ EncryptedData encrypt$commons_release(byte[] bytes) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, IOException, BadPaddingException, NoSuchProviderException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        if (bytes != null && bytes.length > 0) {
            byte[] IV = this.getIV();
            return this.encryptAES$commons_release(bytes, IV);
        }
        return null;
    }

    public final /* synthetic */ byte[] decrypt$commons_release(EncryptedData data) throws IOException, NoSuchPaddingException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidMacException, NoSuchProviderException, InvalidKeyException {
        EncryptedData encryptedData = data;
        return (byte[])(encryptedData != null ? encryptedData.getEncryptedData() : null) != null ? this.decryptAES$commons_release(data) : null;
    }

    public final /* synthetic */ String encrypt$commons_release(String text) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IOException, IllegalBlockSizeException, InvalidAlgorithmParameterException, NoSuchProviderException, BadPaddingException, KeyStoreException, UnrecoverableEntryException {
        if (text != null && text.length() > 0) {
            Charset charset = Charset.forName(DEFAULT_CHARSET);
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
            byte[] byArray = text.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            EncryptedData encryptedData = this.tryEncrypt$commons_release(byArray);
            if (encryptedData == null) {
                return null;
            }
            EncryptedData encrypted = encryptedData;
            return this.encodeEncryptedData(encrypted);
        }
        return null;
    }

    public final /* synthetic */ String decrypt$commons_release(String text) throws IOException, NoSuchPaddingException, InvalidKeyException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, InvalidMacException, NoSuchProviderException, InvalidAlgorithmParameterException, KeyStoreException, UnrecoverableEntryException {
        if (text != null && ((CharSequence)text).length() > 0) {
            EncryptedData encryptedData = this.decodeEncryptedText(text);
            byte[] byArray = this.tryDecrypt$commons_release(encryptedData);
            if (byArray == null) {
                return null;
            }
            byte[] decrypted = byArray;
            int n = decrypted.length;
            Charset charset = Charset.forName(DEFAULT_CHARSET);
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
            return new String(decrypted, 0, n, charset);
        }
        return null;
    }

    private final String encodeEncryptedData(EncryptedData data) throws IOException, NoSuchProviderException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException {
        return data.getMac() != null ? Companion.base64Encode(data.getIV()) + this.DELIMITER + Companion.base64Encode(data.getEncryptedData()) + this.DELIMITER + Companion.base64Encode(data.getMac()) : Companion.base64Encode(data.getIV()) + this.DELIMITER + Companion.base64Encode(data.getEncryptedData());
    }

    /*
     * WARNING - void declaration
     */
    private final EncryptedData decodeEncryptedText(String text) {
        void $this$toTypedArray$iv;
        EncryptedData result = new EncryptedData();
        Object object = text;
        Regex regex = new Regex(this.DELIMITER);
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] parts = stringArray;
        result.setIV(Companion.base64Decode(parts[0]));
        result.setEncryptedData(Companion.base64Decode(parts[1]));
        if (parts.length > 2) {
            result.setMac(Companion.base64Decode(parts[2]));
        }
        return result;
    }

    private final void loadKeyStore() throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keyStore = KeyStore.getInstance(this.KEYSTORE_PROVIDER);
        Intrinsics.checkNotNullExpressionValue((Object)keyStore, (String)"getInstance(KEYSTORE_PROVIDER)");
        this.mStore = keyStore;
        Logger.appendTag("flybits_encryption").d("loadKeyStore");
        KeyStore keyStore2 = this.mStore;
        if (keyStore2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStore");
            keyStore2 = null;
        }
        keyStore2.load(null);
    }

    @NotNull
    public final byte[] getIV() throws UnsupportedEncodingException {
        byte[] iv = new byte[this.IV_LENGTH];
        SecureRandom rng = new SecureRandom();
        rng.nextBytes(iv);
        return iv;
    }

    @TargetApi(value=19)
    private final Cipher getCipherAES(byte[] IV, boolean modeEncrypt) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        Cipher cipher;
        Cipher $this$getCipherAES_u24lambda_u2d0 = cipher = Cipher.getInstance(this.AES_CIPHER);
        boolean bl = false;
        $this$getCipherAES_u24lambda_u2d0.init(modeEncrypt ? 1 : 2, (Key)this.aesKey, new GCMParameterSpec(this.GCM_TAG_LENGTH, IV));
        Cipher cipher2 = cipher;
        Intrinsics.checkNotNullExpressionValue((Object)cipher2, (String)"cipher");
        return cipher2;
    }

    @TargetApi(value=19)
    public final /* synthetic */ EncryptedData encryptAES$commons_release(byte[] bytes, byte[] IV) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, UnsupportedEncodingException {
        EncryptedData result = null;
        try {
            Cipher cipher = this.getCipherAES(IV, true);
            result = new EncryptedData();
            result.setIV(cipher.getIV());
            result.setEncryptedData(cipher.doFinal(bytes));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @TargetApi(value=19)
    public final /* synthetic */ byte[] decryptAES$commons_release(EncryptedData encryptedData) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, UnsupportedEncodingException {
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        Cipher cipher = this.getCipherAES(encryptedData.getIV(), false);
        byte[] byArray = cipher.doFinal(encryptedData.getEncryptedData());
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal(encryptedData.encryptedData)");
        return byArray;
    }

    public final /* synthetic */ void loadKey$commons_release(SharedPreferences prefStore) throws KeyStoreException, UnrecoverableEntryException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, InvalidKeyException, IOException {
        Intrinsics.checkNotNullParameter((Object)prefStore, (String)"prefStore");
        Logger.appendTag("flybits_encryption").d("loadKey");
        KeyStore keyStore = this.mStore;
        if (keyStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStore");
            keyStore = null;
        }
        if (keyStore.containsAlias(this.AES_KEY_ALIAS)) {
            KeyStore keyStore2 = this.mStore;
            if (keyStore2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mStore");
                keyStore2 = null;
            }
            KeyStore.Entry entry = keyStore2.getEntry(this.AES_KEY_ALIAS, null);
            if (entry == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.security.KeyStore.SecretKeyEntry");
            }
            KeyStore.SecretKeyEntry entry2 = (KeyStore.SecretKeyEntry)entry;
            this.aesKey = entry2.getSecretKey();
        }
    }

    public final /* synthetic */ boolean generateKey$commons_release(Context context, byte[] seed, SharedPreferences prefStore) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, UnrecoverableEntryException, NoSuchPaddingException, InvalidKeyException, IOException {
        Intrinsics.checkNotNullParameter((Object)prefStore, (String)"prefStore");
        boolean keyGenerated = false;
        keyGenerated = this.generateAESKey(seed);
        return keyGenerated;
    }

    @TargetApi(value=23)
    private final boolean generateAESKey(byte[] seed) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyStore keyStore = this.mStore;
        if (keyStore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mStore");
            keyStore = null;
        }
        if (!keyStore.containsAlias(this.AES_KEY_ALIAS)) {
            KeyGenerator keyGen = KeyGenerator.getInstance(KEY_ALGORITHM_AES, this.KEYSTORE_PROVIDER);
            Logger.appendTag("flybits_encryption").d("creating a keystore");
            String[] stringArray = new String[]{BLOCK_MODE_GCM};
            KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder(this.AES_KEY_ALIAS, 3).setCertificateSubject(new X500Principal(this.x500_PRINCIPAL)).setCertificateSerialNumber(BigInteger.ONE).setKeySize(this.AES_BIT_LENGTH).setBlockModes(stringArray);
            stringArray = new String[]{ENCRYPTION_PADDING_NONE};
            KeyGenParameterSpec keyGenParameterSpec = builder.setEncryptionPaddings(stringArray).setRandomizedEncryptionRequired(false).build();
            Intrinsics.checkNotNullExpressionValue((Object)keyGenParameterSpec, (String)"Builder(\n               \u2026\n                .build()");
            KeyGenParameterSpec spec = keyGenParameterSpec;
            if (seed != null && !(seed.length == 0)) {
                SecureRandom random = new SecureRandom(seed);
                keyGen.init((AlgorithmParameterSpec)spec, random);
            } else {
                keyGen.init((AlgorithmParameterSpec)spec);
            }
            keyGen.generateKey();
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B%\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0007R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/flybits/commons/library/encryption/EncryptionManager$EncryptedData;", "", "()V", "IV", "", "encryptedData", "mac", "([B[B[B)V", "getIV", "()[B", "setIV", "([B)V", "getEncryptedData", "setEncryptedData", "getMac", "setMac", "commons_release"})
    public static final class EncryptedData {
        @Nullable
        private byte[] IV;
        @Nullable
        private byte[] encryptedData;
        @Nullable
        private byte[] mac;

        @Nullable
        public final byte[] getIV() {
            return this.IV;
        }

        public final void setIV(@Nullable byte[] byArray) {
            this.IV = byArray;
        }

        @Nullable
        public final byte[] getEncryptedData() {
            return this.encryptedData;
        }

        public final void setEncryptedData(@Nullable byte[] byArray) {
            this.encryptedData = byArray;
        }

        @Nullable
        public final byte[] getMac() {
            return this.mac;
        }

        public final void setMac(@Nullable byte[] byArray) {
            this.mac = byArray;
        }

        public EncryptedData() {
            this.IV = null;
            this.encryptedData = null;
            this.mac = null;
        }

        public EncryptedData(@Nullable byte[] IV, @Nullable byte[] encryptedData, @Nullable byte[] mac) {
            this.IV = IV;
            this.encryptedData = encryptedData;
            this.mac = mac;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/flybits/commons/library/encryption/EncryptionManager$InvalidMacException;", "Ljava/security/GeneralSecurityException;", "(Lcom/flybits/commons/library/encryption/EncryptionManager;)V", "commons_release"})
    public final class InvalidMacException
    extends GeneralSecurityException {
        public InvalidMacException() {
            super("Invalid Mac, failed to verify integrity.");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0011\u001a\u00020\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u0013\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/flybits/commons/library/encryption/EncryptionManager$Companion;", "", "()V", "AES_KEY_ALIAS_NAME", "", "BLOCK_MODE_GCM", "DEFAULT_CHARSET", "DEFAULT_KEY_ALIAS_PREFIX", "ENCRYPTION_PADDING_NONE", "IS_COMPAT_MODE_KEY_ALIAS_NAME", "KEY_ALGORITHM_AES", "MAC_KEY_ALIAS_NAME", "OVERRIDING_KEY_ALIAS_PREFIX_NAME", "RSA_KEY_ALIAS_NAME", "base64Decode", "", "text", "base64Encode", "data", "getHashed", "toHex", "commons_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getHashed(@Nullable String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
            CharSequence charSequence = text;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return "";
            }
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            Charset charset = Charset.forName(EncryptionManager.DEFAULT_CHARSET);
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
            byte[] byArray = text.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] result = digest.digest(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
            return this.toHex(result);
        }

        @NotNull
        public final String toHex(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            StringBuilder sb = new StringBuilder();
            for (byte b : data) {
                String string = "%02X";
                Object[] objectArray = new Object[]{b};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                sb.append(string2);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        @NotNull
        public final String base64Encode(@Nullable byte[] data) {
            String string = Base64.encodeToString((byte[])data, (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(data, Base64.NO_WRAP)");
            return string;
        }

        @NotNull
        public final byte[] base64Decode(@Nullable String text) {
            byte[] byArray = Base64.decode((String)text, (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(text, Base64.NO_WRAP)");
            return byArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

