/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.caching;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import com.flybits.commons.library.logging.Logger;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.models.CachingEntry;
import java.util.ArrayList;
import java.util.List;

public abstract class FlybitsUIListObserver<T> {
    private final String TAG = "FlyObserver";
    private final List<T> itemsLoaded;
    private final Context context;
    private DataChanged<T> callback;
    private LiveData<List<T>> item;
    private Observer<List<T>> observer;

    public FlybitsUIListObserver(@NonNull Context context) {
        this.context = context;
        this.itemsLoaded = new ArrayList<T>();
    }

    protected void add(@NonNull String key, DataChanged<T> callback) {
        this.callback = callback;
        new Thread(() -> {
            List<CachingEntry> listOfCacheObjects = CommonsDatabase.getDatabase(this.context).cachingEntryDAO().getByKey(key);
            ArrayList<String> ids = new ArrayList<String>();
            for (CachingEntry entry : listOfCacheObjects) {
                ids.add(entry.getContentId());
            }
            this.onLoad(ids);
        }).start();
    }

    protected Context getContext() {
        return this.context;
    }

    @Nullable
    public LiveData<List<T>> getData() {
        return this.item;
    }

    protected abstract void onLoad(List<String> var1);

    @SuppressLint(value={"RestrictedApi"})
    public void remove() {
        if (ArchTaskExecutor.getInstance().isMainThread()) {
            if (this.item != null && this.item.hasActiveObservers()) {
                this.item.removeObserver(this.observer);
                Logger.appendTag("FlyObserver").d("Successfully removed observer.");
            }
        } else {
            Logger.appendTag("FlyObserver").e("Cannot invoke removeObserver on a background thread");
        }
    }

    public List<T> getItems() {
        return this.itemsLoaded;
    }

    protected void setItems(@NonNull LiveData<List<T>> item) {
        this.item = item;
        this.observer = items -> {
            if (this.callback != null) {
                this.callback.onLoad((List<T>)items);
            }
        };
        Logger.appendTag("FlyObserver").d("Successfully set an observer.");
        new Handler(Looper.getMainLooper()).post(() -> this.item.observeForever(this.observer));
    }

    public static interface DataChanged<T> {
        public void onLoad(List<T> var1);
    }
}

