package com.flybits.internal.db;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Update;

import com.flybits.commons.library.models.User;

@Dao
public interface UserDAO {

    @Query("Select * from user WHERE id IN (:id) LIMIT 1")
    User getSingleById(String id);

    @Query("Select * from user WHERE isActive = 1 LIMIT 1")
    User getActiveUser();

    @Query("Select * from user WHERE isActive = 1 LIMIT 1")
    LiveData<User> getActive();

    @Query("Select * from user WHERE customerID IN (:customerID) and id IN (:userId) LIMIT 1")
    User getSingleByUserAndCustomerId(String userId, String customerID);

    @Query("Select * from user WHERE customerID IN (:customerID) LIMIT 1")
    User getSingleByCustomerId(String customerID);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(User plugins);

    @Query("Delete from user")
    void delete();

    @Query("Delete from user WHERE id IN (:id)")
    void deleteSingle(String id);

    @Update
    void update(User plugin);

    @Query("Update user set isActive = 0")
    void resetAllUsers();
}
