package com.flybits.internal

import java.util.concurrent.TimeUnit

/***
 * The Debounce definition class that will later leverage by the Debouncer class.
 * Deboucer is to ensures that only a single signal will be acted upon for a single opening or closing of a contact.
 * @param uniqueName the ID of this debounce
 * @param wait waiting interval
 * @param unit the time unit of the waiting interval
 */
abstract class Debounce(val uniqueName : String, val wait : Long, val unit : TimeUnit) {

    abstract fun doSomething()

    override fun equals(o: Any?): Boolean {
        if (this === o) return true
        if (o !is Debounce) {
            return false
        }
        return o.uniqueName == uniqueName
    }

    override fun hashCode(): Int {
        return uniqueName.hashCode()
    }
}