package com.flybits.commons.library.api.idps

import android.content.Context
import android.os.Parcel
import android.os.Parcelable
import com.flybits.commons.library.models.User
import org.json.JSONObject
import java.util.*

private const val USERAGENT_ENDPOINT = "/sso/devices/xuseragent"
private const val ME_ENDPOINT = "/me"

private const val JWT_PROVIDER = "jwt"

/**
 * The [JwtIDP] class is responsible for accepting the token and authenticating the User.
 *
 */
class JwtIDP : IDP {

    private val jwt: String

    /**
     * Constructor used for JWTIDP.
     *
     * @param jwt The Token is a security token that contains Claims about the Authentication
     *                  of an End-User by an Authorization Server.
     */
    constructor(jwt: String) : super(JWT_PROVIDER) {
        this.jwt = jwt
    }

    /**
     * Constructor used to read the data
     *
     * @param parcel The parcel is for reading the attribute idToken
     *
     */
    constructor(parcel: Parcel) : super(parcel) {
        jwt = parcel.readString() ?: ""
    }

    override fun getRequestType(): HttpMethod {
        return HttpMethod.POST
    }

    override fun getHeaders(): HashMap<String, String> {
        val headers = HashMap<String, String>()
        headers["X-Authorization"] = jwt
        return headers
    }

    fun getUserInfoEndPoint() = ME_ENDPOINT

    override fun describeContents() = 0

    override fun onAuthenticated(context: Context, user: User) {}

    override val authenticationEndPoint: String
        get() = USERAGENT_ENDPOINT

    override fun getBody(): JSONObject? = null

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        super.writeToParcel(parcel, flags)
        parcel.writeString(jwt)
    }

    companion object CREATOR : Parcelable.Creator<JwtIDP> {
        override fun createFromParcel(parcel: Parcel): JwtIDP {
            return JwtIDP(parcel)
        }

        override fun newArray(size: Int): Array<JwtIDP?> {
            return arrayOfNulls(size)
        }
    }
}