/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.internal.db;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.flybits.commons.library.models.User;
import com.flybits.internal.db.UserDAO;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public final class UserDAO_Impl
implements UserDAO {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<User> __insertionAdapterOfUser;
    private final EntityDeletionOrUpdateAdapter<User> __updateAdapterOfUser;
    private final SharedSQLiteStatement __preparedStmtOfDelete;
    private final SharedSQLiteStatement __preparedStmtOfDeleteSingle;
    private final SharedSQLiteStatement __preparedStmtOfResetAllUsers;

    public UserDAO_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfUser = new EntityInsertionAdapter<User>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `user` (`deviceID`,`email`,`firstName`,`id`,`lastName`,`isVerified`,`isOptedIn`,`isActive`,`customerID`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, User value) {
                if (value.getDeviceID() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getDeviceID());
                }
                if (value.getEmail() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getEmail());
                }
                if (value.getFirstName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getFirstName());
                }
                if (value.getId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getId());
                }
                if (value.getLastName() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getLastName());
                }
                int _tmp = value.isVerified() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp);
                int _tmp_1 = value.isOptedIn() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_1);
                int _tmp_2 = value.isActive() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_2);
                if (value.getCustomerID() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getCustomerID());
                }
            }
        };
        this.__updateAdapterOfUser = new EntityDeletionOrUpdateAdapter<User>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `user` SET `deviceID` = ?,`email` = ?,`firstName` = ?,`id` = ?,`lastName` = ?,`isVerified` = ?,`isOptedIn` = ?,`isActive` = ?,`customerID` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, User value) {
                if (value.getDeviceID() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getDeviceID());
                }
                if (value.getEmail() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getEmail());
                }
                if (value.getFirstName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getFirstName());
                }
                if (value.getId() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getId());
                }
                if (value.getLastName() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getLastName());
                }
                int _tmp = value.isVerified() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp);
                int _tmp_1 = value.isOptedIn() ? 1 : 0;
                stmt.bindLong(7, (long)_tmp_1);
                int _tmp_2 = value.isActive() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_2);
                if (value.getCustomerID() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getCustomerID());
                }
                if (value.getId() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getId());
                }
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Delete from user";
                return "Delete from user";
            }
        };
        this.__preparedStmtOfDeleteSingle = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Delete from user WHERE id IN (?)";
                return "Delete from user WHERE id IN (?)";
            }
        };
        this.__preparedStmtOfResetAllUsers = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Update user set isActive = 0";
                return "Update user set isActive = 0";
            }
        };
    }

    @Override
    public void insert(User plugins) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfUser.insert((Object)plugins);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(User plugin) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfUser.handle((Object)plugin);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDelete.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDelete.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSingle(String id) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteSingle.acquire();
        int _argIndex = 1;
        if (id == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, id);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteSingle.release(_stmt);
        }
    }

    @Override
    public void resetAllUsers() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfResetAllUsers.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfResetAllUsers.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getSingleById(String id) {
        String _sql = "Select * from user WHERE id IN (?) LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from user WHERE id IN (?) LIMIT 1", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            User _result;
            int _cursorIndexOfDeviceID = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceID");
            int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
            int _cursorIndexOfFirstName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstName");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
            int _cursorIndexOfIsVerified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isVerified");
            int _cursorIndexOfIsOptedIn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isOptedIn");
            int _cursorIndexOfIsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isActive");
            int _cursorIndexOfCustomerID = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"customerID");
            if (_cursor.moveToFirst()) {
                _result = new User();
                String _tmpDeviceID = _cursor.isNull(_cursorIndexOfDeviceID) ? null : _cursor.getString(_cursorIndexOfDeviceID);
                _result.setDeviceID(_tmpDeviceID);
                String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                _result.setEmail(_tmpEmail);
                String _tmpFirstName = _cursor.isNull(_cursorIndexOfFirstName) ? null : _cursor.getString(_cursorIndexOfFirstName);
                _result.setFirstName(_tmpFirstName);
                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                _result.setLastName(_tmpLastName);
                int _tmp = _cursor.getInt(_cursorIndexOfIsVerified);
                boolean _tmpIsVerified = _tmp != 0;
                _result.setIsVerified(_tmpIsVerified);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsOptedIn);
                boolean _tmpIsOptedIn = _tmp_1 != 0;
                _result.setOptedIn(_tmpIsOptedIn);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsActive);
                boolean _tmpIsActive = _tmp_2 != 0;
                _result.setActive(_tmpIsActive);
                String _tmpCustomerID = _cursor.isNull(_cursorIndexOfCustomerID) ? null : _cursor.getString(_cursorIndexOfCustomerID);
                _result.setCustomerID(_tmpCustomerID);
            } else {
                _result = null;
            }
            User user = _result;
            return user;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getActiveUser() {
        String _sql = "Select * from user WHERE isActive = 1 LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from user WHERE isActive = 1 LIMIT 1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            User _result;
            int _cursorIndexOfDeviceID = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceID");
            int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
            int _cursorIndexOfFirstName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstName");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
            int _cursorIndexOfIsVerified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isVerified");
            int _cursorIndexOfIsOptedIn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isOptedIn");
            int _cursorIndexOfIsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isActive");
            int _cursorIndexOfCustomerID = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"customerID");
            if (_cursor.moveToFirst()) {
                _result = new User();
                String _tmpDeviceID = _cursor.isNull(_cursorIndexOfDeviceID) ? null : _cursor.getString(_cursorIndexOfDeviceID);
                _result.setDeviceID(_tmpDeviceID);
                String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                _result.setEmail(_tmpEmail);
                String _tmpFirstName = _cursor.isNull(_cursorIndexOfFirstName) ? null : _cursor.getString(_cursorIndexOfFirstName);
                _result.setFirstName(_tmpFirstName);
                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                _result.setLastName(_tmpLastName);
                int _tmp = _cursor.getInt(_cursorIndexOfIsVerified);
                boolean _tmpIsVerified = _tmp != 0;
                _result.setIsVerified(_tmpIsVerified);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsOptedIn);
                boolean _tmpIsOptedIn = _tmp_1 != 0;
                _result.setOptedIn(_tmpIsOptedIn);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsActive);
                boolean _tmpIsActive = _tmp_2 != 0;
                _result.setActive(_tmpIsActive);
                String _tmpCustomerID = _cursor.isNull(_cursorIndexOfCustomerID) ? null : _cursor.getString(_cursorIndexOfCustomerID);
                _result.setCustomerID(_tmpCustomerID);
            } else {
                _result = null;
            }
            User user = _result;
            return user;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<User> getActive() {
        String _sql = "Select * from user WHERE isActive = 1 LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from user WHERE isActive = 1 LIMIT 1", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"user"}, false, (Callable)new Callable<User>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public User call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)UserDAO_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    User _result;
                    int _cursorIndexOfDeviceID = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceID");
                    int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
                    int _cursorIndexOfFirstName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstName");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
                    int _cursorIndexOfIsVerified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isVerified");
                    int _cursorIndexOfIsOptedIn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isOptedIn");
                    int _cursorIndexOfIsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isActive");
                    int _cursorIndexOfCustomerID = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"customerID");
                    if (_cursor.moveToFirst()) {
                        _result = new User();
                        String _tmpDeviceID = _cursor.isNull(_cursorIndexOfDeviceID) ? null : _cursor.getString(_cursorIndexOfDeviceID);
                        _result.setDeviceID(_tmpDeviceID);
                        String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                        _result.setEmail(_tmpEmail);
                        String _tmpFirstName = _cursor.isNull(_cursorIndexOfFirstName) ? null : _cursor.getString(_cursorIndexOfFirstName);
                        _result.setFirstName(_tmpFirstName);
                        String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                        _result.setId(_tmpId);
                        String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                        _result.setLastName(_tmpLastName);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsVerified);
                        boolean _tmpIsVerified = _tmp != 0;
                        _result.setIsVerified(_tmpIsVerified);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsOptedIn);
                        boolean _tmpIsOptedIn = _tmp_1 != 0;
                        _result.setOptedIn(_tmpIsOptedIn);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfIsActive);
                        boolean _tmpIsActive = _tmp_2 != 0;
                        _result.setActive(_tmpIsActive);
                        String _tmpCustomerID = _cursor.isNull(_cursorIndexOfCustomerID) ? null : _cursor.getString(_cursorIndexOfCustomerID);
                        _result.setCustomerID(_tmpCustomerID);
                    } else {
                        _result = null;
                    }
                    User user = _result;
                    return user;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getSingleByUserAndCustomerId(String userId, String customerID) {
        String _sql = "Select * from user WHERE customerID IN (?) and id IN (?) LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from user WHERE customerID IN (?) and id IN (?) LIMIT 1", (int)2);
        int _argIndex = 1;
        if (customerID == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, customerID);
        }
        _argIndex = 2;
        if (userId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, userId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            User _result;
            int _cursorIndexOfDeviceID = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceID");
            int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
            int _cursorIndexOfFirstName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstName");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
            int _cursorIndexOfIsVerified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isVerified");
            int _cursorIndexOfIsOptedIn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isOptedIn");
            int _cursorIndexOfIsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isActive");
            int _cursorIndexOfCustomerID = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"customerID");
            if (_cursor.moveToFirst()) {
                _result = new User();
                String _tmpDeviceID = _cursor.isNull(_cursorIndexOfDeviceID) ? null : _cursor.getString(_cursorIndexOfDeviceID);
                _result.setDeviceID(_tmpDeviceID);
                String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                _result.setEmail(_tmpEmail);
                String _tmpFirstName = _cursor.isNull(_cursorIndexOfFirstName) ? null : _cursor.getString(_cursorIndexOfFirstName);
                _result.setFirstName(_tmpFirstName);
                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                _result.setLastName(_tmpLastName);
                int _tmp = _cursor.getInt(_cursorIndexOfIsVerified);
                boolean _tmpIsVerified = _tmp != 0;
                _result.setIsVerified(_tmpIsVerified);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsOptedIn);
                boolean _tmpIsOptedIn = _tmp_1 != 0;
                _result.setOptedIn(_tmpIsOptedIn);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsActive);
                boolean _tmpIsActive = _tmp_2 != 0;
                _result.setActive(_tmpIsActive);
                String _tmpCustomerID = _cursor.isNull(_cursorIndexOfCustomerID) ? null : _cursor.getString(_cursorIndexOfCustomerID);
                _result.setCustomerID(_tmpCustomerID);
            } else {
                _result = null;
            }
            User user = _result;
            return user;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getSingleByCustomerId(String customerID) {
        String _sql = "Select * from user WHERE customerID IN (?) LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * from user WHERE customerID IN (?) LIMIT 1", (int)1);
        int _argIndex = 1;
        if (customerID == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, customerID);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            User _result;
            int _cursorIndexOfDeviceID = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deviceID");
            int _cursorIndexOfEmail = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"email");
            int _cursorIndexOfFirstName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"firstName");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfLastName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"lastName");
            int _cursorIndexOfIsVerified = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isVerified");
            int _cursorIndexOfIsOptedIn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isOptedIn");
            int _cursorIndexOfIsActive = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isActive");
            int _cursorIndexOfCustomerID = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"customerID");
            if (_cursor.moveToFirst()) {
                _result = new User();
                String _tmpDeviceID = _cursor.isNull(_cursorIndexOfDeviceID) ? null : _cursor.getString(_cursorIndexOfDeviceID);
                _result.setDeviceID(_tmpDeviceID);
                String _tmpEmail = _cursor.isNull(_cursorIndexOfEmail) ? null : _cursor.getString(_cursorIndexOfEmail);
                _result.setEmail(_tmpEmail);
                String _tmpFirstName = _cursor.isNull(_cursorIndexOfFirstName) ? null : _cursor.getString(_cursorIndexOfFirstName);
                _result.setFirstName(_tmpFirstName);
                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                _result.setId(_tmpId);
                String _tmpLastName = _cursor.isNull(_cursorIndexOfLastName) ? null : _cursor.getString(_cursorIndexOfLastName);
                _result.setLastName(_tmpLastName);
                int _tmp = _cursor.getInt(_cursorIndexOfIsVerified);
                boolean _tmpIsVerified = _tmp != 0;
                _result.setIsVerified(_tmpIsVerified);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsOptedIn);
                boolean _tmpIsOptedIn = _tmp_1 != 0;
                _result.setOptedIn(_tmpIsOptedIn);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsActive);
                boolean _tmpIsActive = _tmp_2 != 0;
                _result.setActive(_tmpIsActive);
                String _tmpCustomerID = _cursor.isNull(_cursorIndexOfCustomerID) ? null : _cursor.getString(_cursorIndexOfCustomerID);
                _result.setCustomerID(_tmpCustomerID);
            } else {
                _result = null;
            }
            User user = _result;
            return user;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

