/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library.analytics;

import android.content.Context;
import androidx.work.Constraints;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.NetworkType;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.flybits.commons.library.analytics.Analytics;
import com.flybits.commons.library.analytics.ContextReporterWorker;
import com.flybits.commons.library.api.FlyAway;
import com.flybits.commons.library.exceptions.FlybitsException;
import com.flybits.commons.library.http.RequestStatus;
import com.flybits.commons.library.logging.Displayer;
import com.flybits.commons.library.logging.Logger;
import com.flybits.commons.library.models.CtxData;
import com.flybits.commons.library.models.State;
import com.flybits.commons.library.models.internal.Result;
import com.flybits.internal.db.CommonsDatabase;
import com.flybits.internal.db.CtxDataDAO;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 (2\u00020\u0001:\u0002'(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\tH\u0002J\u0006\u0010\u000b\u001a\u00020\tJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0006\u0010\u0011\u001a\u00020\tJ\u0012\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015H\u0002JL\u0010\u0016\u001a\u00020\t2B\b\u0002\u0010\u0017\u001a<\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u001b\u0012\u0019\u0018\u00010\u001cj\u0004\u0018\u0001`\u001d\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\t\u0018\u00010\u0018H\u0002JT\u0010\u0016\u001a\u00020\t2B\b\u0002\u0010\u0017\u001a<\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u001b\u0012\u0019\u0018\u00010\u001cj\u0004\u0018\u0001`\u001d\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\t\u0018\u00010\u00182\b\b\u0002\u0010\u001f\u001a\u00020\rJ\b\u0010 \u001a\u00020\tH\u0002J\b\u0010!\u001a\u00020\tH\u0002J\u0006\u0010\"\u001a\u00020\tJ\u0010\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020%H\u0004J\f\u0010&\u001a\u00020\u000f*\u00020%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/flybits/commons/library/analytics/Analytics;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "ctxDataDAO", "Lcom/flybits/internal/db/CtxDataDAO;", "kotlin.jvm.PlatformType", "cancelMeteredWork", "", "cancelUnmeteredWork", "cancelWorkers", "checkIfUnique", "", "ctxData", "Lcom/flybits/commons/library/models/CtxData;", "checkIfUnique$commons_release", "destroy", "exceptionHandlerBuilder", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "text", "", "flush", "callback", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "success", "Ljava/lang/Exception;", "Lkotlin/Exception;", "exception", "async", "scheduleMeteredWorker", "scheduleUnmeteredWorker", "scheduleWorkers", "track", "event", "Lcom/flybits/commons/library/analytics/Analytics$AnalyticsEvent;", "toCtxData", "AnalyticsEvent", "Companion", "commons_release"})
public class Analytics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    private final CtxDataDAO ctxDataDAO;
    @NotNull
    public static final String TAG_METERED_WORK = "com.flybits.commons.library.analytics.meteredWork";
    @NotNull
    public static final String TAG_UNMETERED_WORK = "com.flybits.commons.library.analytics.unmeteredWork";

    public Analytics(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.ctxDataDAO = CommonsDatabase.getDatabase(this.context).ctxDataDAO();
    }

    private final CoroutineExceptionHandler exceptionHandlerBuilder(String text) {
        boolean $i$f$CoroutineExceptionHandler = false;
        CoroutineExceptionHandler.Key key = CoroutineExceptionHandler.Key;
        return new CoroutineExceptionHandler(key, text){
            final /* synthetic */ String $text$inlined;
            {
                this.$text$inlined = string;
                super((CoroutineContext.Key)$super_call_param$1);
            }

            public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
                boolean bl = false;
                Logger.appendTag("Analytics").e(this.$text$inlined);
            }
        };
    }

    static /* synthetic */ CoroutineExceptionHandler exceptionHandlerBuilder$default(Analytics analytics, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exceptionHandlerBuilder");
        }
        if ((n & 1) != 0) {
            string = "Error executing the CoroutineScope";
        }
        return analytics.exceptionHandlerBuilder(string);
    }

    private final CtxData toCtxData(AnalyticsEvent $this$toCtxData) {
        JSONObject analyticsJson = new JSONObject();
        String dataTypeID = "ctx.flybits." + $this$toCtxData.getAnalyticsScope();
        analyticsJson.put("dataTypeID", (Object)dataTypeID);
        JSONObject valueJson = new JSONObject();
        if (((CharSequence)$this$toCtxData.getValueString()).length() > 0) {
            valueJson.put($this$toCtxData.getAction(), (Object)$this$toCtxData.getValueString());
        } else {
            valueJson.put($this$toCtxData.getAction(), $this$toCtxData.getValue());
        }
        analyticsJson.put("value", (Object)valueJson);
        analyticsJson.put("timestamp", $this$toCtxData.getTimestamp() / (long)1000);
        long l = $this$toCtxData.getTimestamp();
        String string = analyticsJson.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"analyticsJson.toString()");
        return new CtxData(0L, l, string, dataTypeID, null, 17, null);
    }

    public final void flush(@Nullable Function2<? super Boolean, ? super Exception, Unit> callback, boolean async) throws FlybitsException {
        Logger.appendTag("Analytics").i("Flushing analytics data");
        if (async) {
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), (CoroutineContext)((CoroutineContext)this.exceptionHandlerBuilder("Failed to execute CoroutineScope in Analytics.flush().")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, callback, null){
                int label;
                final /* synthetic */ Analytics this$0;
                final /* synthetic */ Function2<Boolean, Exception, Unit> $callback;
                {
                    this.this$0 = $receiver;
                    this.$callback = $callback;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            try {
                                Analytics.access$flush(this.this$0, this.$callback);
                            }
                            catch (Exception e) {
                                Function2<Boolean, Exception, Unit> function2 = this.$callback;
                                if (function2 != null) {
                                    function2.invoke((Object)Boxing.boxBoolean((boolean)false), (Object)e);
                                }
                                Logger.appendTag("Analytics").e("Flushing analytics data failed", e);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        } else {
            this.flush(callback);
        }
    }

    public static /* synthetic */ void flush$default(Analytics analytics, Function2 function2, boolean bl, int n, Object object) throws FlybitsException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: flush");
        }
        if ((n & 1) != 0) {
            function2 = null;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        analytics.flush((Function2<? super Boolean, ? super Exception, Unit>)function2, bl);
    }

    private final void flush(Function2<? super Boolean, ? super Exception, Unit> callback) throws FlybitsException {
        try {
            CtxDataDAO ctxDataDAO = CommonsDatabase.getDatabase(this.context).ctxDataDAO();
            List<CtxData> ctxData = ctxDataDAO.getAllByState(State.PENDING);
            Collection collection = ctxData;
            if (!(collection == null || collection.isEmpty())) {
                Logger.appendTag("Analytics").i("Flushing analytics data - Non-Empty list");
                Iterable $this$forEach$iv = ctxData;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CtxData it = (CtxData)element$iv;
                    boolean bl = false;
                    it.setState(State.INFLIGHT);
                }
                ctxDataDAO.updateCtxData((Collection<CtxData>)ctxData);
                String body2 = CollectionsKt.joinToString$default((Iterable)ctxData, (CharSequence)",", (CharSequence)"[", (CharSequence)"]", (int)0, null, (Function1)flush.body.1.INSTANCE, (int)24, null);
                Result result = FlyAway.post(this.context, "/context/ctxdata", body2, null, "AnalyticsWorker.doWork", null);
                if (result.getStatus() == RequestStatus.COMPLETED) {
                    CtxDataDAO ctxDataDAO2 = ctxDataDAO;
                    if (ctxDataDAO2 != null) {
                        ctxDataDAO2.deleteMany((Collection<CtxData>)ctxData);
                    }
                    Function2<? super Boolean, ? super Exception, Unit> function2 = callback;
                    if (function2 != null) {
                        function2.invoke((Object)true, null);
                    }
                    Logger.appendTag("Analytics").i("Flushing analytics data success");
                } else {
                    Iterable $this$forEach$iv2 = ctxData;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        CtxData it = (CtxData)element$iv;
                        boolean bl = false;
                        it.setState(State.PENDING);
                    }
                    ctxDataDAO.updateCtxData((Collection<CtxData>)ctxData);
                    Function2<? super Boolean, ? super Exception, Unit> function2 = callback;
                    if (function2 != null) {
                        function2.invoke((Object)false, (Object)result.getException());
                    }
                    Displayer displayer = Logger.appendTag("Analytics");
                    FlybitsException flybitsException = result.getException();
                    Intrinsics.checkNotNullExpressionValue((Object)flybitsException, (String)"result.exception");
                    displayer.e("Flushing analytics data failed", flybitsException);
                }
            } else {
                Function2<? super Boolean, ? super Exception, Unit> function2 = callback;
                if (function2 != null) {
                    function2.invoke((Object)true, null);
                }
                Logger.appendTag("Analytics").i("Flushing analytics data - Empty list, nothing sent");
            }
        }
        catch (Exception e) {
            Function2<? super Boolean, ? super Exception, Unit> function2 = callback;
            if (function2 != null) {
                function2.invoke((Object)false, (Object)e);
            }
            Logger.appendTag("Analytics").e("Flushing analytics data failed", e);
        }
    }

    static /* synthetic */ void flush$default(Analytics analytics, Function2 function2, int n, Object object) throws FlybitsException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: flush");
        }
        if ((n & 1) != 0) {
            function2 = null;
        }
        analytics.flush((Function2<? super Boolean, ? super Exception, Unit>)function2);
    }

    public final void scheduleWorkers() {
        this.scheduleMeteredWorker();
        this.scheduleUnmeteredWorker();
        Logger.appendTag("Analytics").i("Analytics workers are scheduled");
    }

    public final void cancelWorkers() {
        this.cancelUnmeteredWork();
        this.cancelMeteredWork();
        Logger.appendTag("Analytics").i("Analytics workers are cancelled");
    }

    public final void destroy() {
        this.cancelWorkers();
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), (CoroutineContext)((CoroutineContext)this.exceptionHandlerBuilder("Failed to execute CoroutineScope in Analytics.destroy().")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ Analytics this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CtxDataDAO ctxDataDAO = Analytics.access$getCtxDataDAO$p(this.this$0);
                        if (ctxDataDAO != null) {
                            ctxDataDAO.deleteAll();
                        }
                        Logger.appendTag("Analytics").i("Ctxdata database in Commons cleared");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void cancelUnmeteredWork() {
        WorkManager.getInstance((Context)this.context).cancelUniqueWork(TAG_UNMETERED_WORK);
    }

    private final void cancelMeteredWork() {
        WorkManager.getInstance((Context)this.context).cancelUniqueWork(TAG_METERED_WORK);
    }

    private final void scheduleMeteredWorker() {
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.METERED).build();
        Intrinsics.checkNotNullExpressionValue((Object)constraints, (String)"Builder()\n              \u2026\n                .build()");
        Constraints constraintsMetered = constraints;
        WorkRequest workRequest = ((PeriodicWorkRequest.Builder)((PeriodicWorkRequest.Builder)new PeriodicWorkRequest.Builder(ContextReporterWorker.class, 60L, TimeUnit.MINUTES).setConstraints(constraintsMetered)).addTag(TAG_METERED_WORK)).build();
        Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"Builder(ContextReporterW\u2026\n                .build()");
        PeriodicWorkRequest workRequestMetered = (PeriodicWorkRequest)workRequest;
        WorkManager.getInstance((Context)this.context).enqueueUniquePeriodicWork(TAG_METERED_WORK, ExistingPeriodicWorkPolicy.KEEP, workRequestMetered);
    }

    private final void scheduleUnmeteredWorker() {
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.UNMETERED).build();
        Intrinsics.checkNotNullExpressionValue((Object)constraints, (String)"Builder()\n              \u2026\n                .build()");
        Constraints constraintsMetered = constraints;
        WorkRequest workRequest = ((PeriodicWorkRequest.Builder)((PeriodicWorkRequest.Builder)new PeriodicWorkRequest.Builder(ContextReporterWorker.class, 20L, TimeUnit.MINUTES).setConstraints(constraintsMetered)).addTag(TAG_UNMETERED_WORK)).build();
        Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"Builder(ContextReporterW\u2026\n                .build()");
        PeriodicWorkRequest workRequestMetered = (PeriodicWorkRequest)workRequest;
        WorkManager.getInstance((Context)this.context).enqueueUniquePeriodicWork(TAG_UNMETERED_WORK, ExistingPeriodicWorkPolicy.KEEP, workRequestMetered);
    }

    protected final void track(@NotNull AnalyticsEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), (CoroutineContext)((CoroutineContext)this.exceptionHandlerBuilder("Failed to execute CoroutineScope in Analytics.track().")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, null){
            int label;
            final /* synthetic */ Analytics this$0;
            final /* synthetic */ AnalyticsEvent $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            CtxData data = Analytics.access$toCtxData(this.this$0, this.$event);
                            Logger.appendTag("Analytics").i("Received event: " + data);
                            if (this.this$0.checkIfUnique$commons_release(data)) {
                                CtxDataDAO ctxDataDAO = Analytics.access$getCtxDataDAO$p(this.this$0);
                                if (ctxDataDAO != null) {
                                    ctxDataDAO.insert(data);
                                }
                                Logger.appendTag("Analytics").i("Recorded event: " + data.getId() + " - " + data.getValue());
                            }
                        }
                        catch (Exception e) {
                            Logger.appendTag("Analytics").e("Tracking analytics data failed", e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean checkIfUnique$commons_release(@NotNull CtxData ctxData) {
        Intrinsics.checkNotNullParameter((Object)ctxData, (String)"ctxData");
        Analytics analytics = this;
        synchronized (analytics) {
            boolean bl = false;
            CtxDataDAO ctxDataDAO = this.ctxDataDAO;
            CtxData dataFromCursor = ctxDataDAO != null ? ctxDataDAO.getDataByValue(ctxData.getValue()) : null;
            boolean bl2 = dataFromCursor == null;
            return bl2;
        }
    }

    public static final /* synthetic */ void access$flush(Analytics $this, Function2 callback) {
        $this.flush((Function2<? super Boolean, ? super Exception, Unit>)callback);
    }

    public static final /* synthetic */ CtxDataDAO access$getCtxDataDAO$p(Analytics $this) {
        return $this.ctxDataDAO;
    }

    public static final /* synthetic */ CtxData access$toCtxData(Analytics $this, AnalyticsEvent $receiver) {
        return $this.toCtxData($receiver);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/flybits/commons/library/analytics/Analytics$Companion;", "", "()V", "TAG_METERED_WORK", "", "TAG_UNMETERED_WORK", "commons_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/flybits/commons/library/analytics/Analytics$AnalyticsEvent;", "", "analyticsScope", "", "action", "value", "", "timestamp", "", "valueString", "(Ljava/lang/String;Ljava/lang/String;ZJLjava/lang/String;)V", "getAction", "()Ljava/lang/String;", "getAnalyticsScope", "getTimestamp", "()J", "getValue", "()Z", "getValueString", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "commons_release"})
    public static final class AnalyticsEvent {
        @NotNull
        private final String analyticsScope;
        @NotNull
        private final String action;
        private final boolean value;
        private final long timestamp;
        @NotNull
        private final String valueString;

        public AnalyticsEvent(@NotNull String analyticsScope, @NotNull String action, boolean value, long timestamp, @NotNull String valueString) {
            Intrinsics.checkNotNullParameter((Object)analyticsScope, (String)"analyticsScope");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)valueString, (String)"valueString");
            this.analyticsScope = analyticsScope;
            this.action = action;
            this.value = value;
            this.timestamp = timestamp;
            this.valueString = valueString;
        }

        public /* synthetic */ AnalyticsEvent(String string, String string2, boolean bl, long l, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 0x10) != 0) {
                string3 = "";
            }
            this(string, string2, bl, l, string3);
        }

        @NotNull
        public final String getAnalyticsScope() {
            return this.analyticsScope;
        }

        @NotNull
        public final String getAction() {
            return this.action;
        }

        public final boolean getValue() {
            return this.value;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final String getValueString() {
            return this.valueString;
        }

        @NotNull
        public final String component1() {
            return this.analyticsScope;
        }

        @NotNull
        public final String component2() {
            return this.action;
        }

        public final boolean component3() {
            return this.value;
        }

        public final long component4() {
            return this.timestamp;
        }

        @NotNull
        public final String component5() {
            return this.valueString;
        }

        @NotNull
        public final AnalyticsEvent copy(@NotNull String analyticsScope, @NotNull String action, boolean value, long timestamp, @NotNull String valueString) {
            Intrinsics.checkNotNullParameter((Object)analyticsScope, (String)"analyticsScope");
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            Intrinsics.checkNotNullParameter((Object)valueString, (String)"valueString");
            return new AnalyticsEvent(analyticsScope, action, value, timestamp, valueString);
        }

        public static /* synthetic */ AnalyticsEvent copy$default(AnalyticsEvent analyticsEvent, String string, String string2, boolean bl, long l, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = analyticsEvent.analyticsScope;
            }
            if ((n & 2) != 0) {
                string2 = analyticsEvent.action;
            }
            if ((n & 4) != 0) {
                bl = analyticsEvent.value;
            }
            if ((n & 8) != 0) {
                l = analyticsEvent.timestamp;
            }
            if ((n & 0x10) != 0) {
                string3 = analyticsEvent.valueString;
            }
            return analyticsEvent.copy(string, string2, bl, l, string3);
        }

        @NotNull
        public String toString() {
            return "AnalyticsEvent(analyticsScope=" + this.analyticsScope + ", action=" + this.action + ", value=" + this.value + ", timestamp=" + this.timestamp + ", valueString=" + this.valueString + ')';
        }

        public int hashCode() {
            int result = this.analyticsScope.hashCode();
            result = result * 31 + this.action.hashCode();
            int n = this.value ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + Long.hashCode(this.timestamp);
            result = result * 31 + this.valueString.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnalyticsEvent)) {
                return false;
            }
            AnalyticsEvent analyticsEvent = (AnalyticsEvent)other;
            if (!Intrinsics.areEqual((Object)this.analyticsScope, (Object)analyticsEvent.analyticsScope)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.action, (Object)analyticsEvent.action)) {
                return false;
            }
            if (this.value != analyticsEvent.value) {
                return false;
            }
            if (this.timestamp != analyticsEvent.timestamp) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.valueString, (Object)analyticsEvent.valueString);
        }
    }
}

