/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.commons.library;

import android.content.Context;
import android.content.SharedPreferences;
import com.flybits.commons.library.SharedElements;
import com.flybits.commons.library.utils.Utilities;
import com.flybits.internal.db.UserDAO;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/flybits/commons/library/UnsecuredSharedElements;", "Lcom/flybits/commons/library/SharedElements;", "sharedPreferences", "Landroid/content/SharedPreferences;", "userDAO", "Lcom/flybits/internal/db/UserDAO;", "(Landroid/content/SharedPreferences;Lcom/flybits/internal/db/UserDAO;)V", "performMigration", "", "context", "Landroid/content/Context;", "setBooleanVariable", "", "key", "", "value", "", "setStringVariable", "commons_release"})
public final class UnsecuredSharedElements
extends SharedElements {
    public UnsecuredSharedElements(@NotNull SharedPreferences sharedPreferences, @NotNull UserDAO userDAO) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        Intrinsics.checkNotNullParameter((Object)userDAO, (String)"userDAO");
        super(sharedPreferences, userDAO, null, 4, null);
    }

    @Override
    protected int performMigration(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SharedPreferences backupPreferences = context.getSharedPreferences("FLYBITS_PREF_BACKUP", 0);
        int migratedCount = 0;
        if (backupPreferences.contains("com.flybits.jwt.token")) {
            String string = backupPreferences.getString("com.flybits.jwt.token", "");
            if (string == null) {
                string = "";
            }
            this.setJWTToken(string);
            ++migratedCount;
        }
        if (backupPreferences.contains("com.flybits.idp.connected")) {
            String string = backupPreferences.getString("com.flybits.idp.connected", "");
            if (string == null) {
                string = "";
            }
            this.setConnectedIDP(string);
            ++migratedCount;
        }
        if (backupPreferences.contains("com.flybits.language.codes")) {
            this.setLocalization(Utilities.convertLocalizationStringToList(backupPreferences.getString("com.flybits.language.codes", "")));
            ++migratedCount;
        }
        if (migratedCount > 0) {
            backupPreferences.edit().clear().apply();
        }
        return migratedCount;
    }

    @Override
    public void setStringVariable(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putString(key, value);
        editor.apply();
    }

    @Override
    public void setBooleanVariable(@NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putBoolean(key, value);
        editor.apply();
    }
}

