package com.flybits.commons.library.utils

import android.content.Context
import com.flybits.commons.library.SharedElementsFactory
import com.flybits.commons.library.api.ScopeAuthState
import com.flybits.commons.library.logging.Logger
import com.flybits.commons.library.models.Jwt
import com.flybits.commons.library.models.User
import java.util.*

/**
 * @return [ScopeAuthState] stating the status of either [User] provided or checking the JWT from [SharedElementsFactory]
 */
fun getAuthenticationState(context: Context, user: User? = null): ScopeAuthState {
    return try {
        if (user == null) {
            val savedJwt = SharedElementsFactory.get(context).getSavedJWTToken()
            if (savedJwt.isNotEmpty()) { // Make sure there is a JWT locally.
                // Only return true if the JWT decoded is not expired.
                if (Jwt.decodeJWTToken(savedJwt).expiry > Date().time / 1000) {
                    SharedElementsFactory.get(context).getUser()?.let {
                        if (it.isOptedIn) {
                            ScopeAuthState.CONNECTED_OPT_IN
                        } else {
                            ScopeAuthState.CONNECTED_OPT_OUT
                        }
                    } ?: run {
                        ScopeAuthState.DISCONNECTED
                    }
                } else {
                    Logger.i("Retrieved JWT is expired.")
                    ScopeAuthState.DISCONNECTED
                }
            } else {
                Logger.i("JWT is empty.")
                ScopeAuthState.DISCONNECTED
            }
        } else {
            if (user.isOptedIn) {
                ScopeAuthState.CONNECTED_OPT_IN
            } else {
                ScopeAuthState.CONNECTED_OPT_OUT
            }
        }
    } catch (e: Exception) {
        Logger.i("Failed to retrieve JWT information: $e")
        ScopeAuthState.DISCONNECTED
    }
}